/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.uon.UonBeanPropertyMeta;
import org.apache.juneau.uon.UonClassMeta;
import org.apache.juneau.uon.UonCommon;
import org.apache.juneau.uon.UonMetaProvider;
import org.apache.juneau.uon.UonParserBuilder;
import org.apache.juneau.uon.UonParserSession;

@ConfigurableContext
public class UonParser
extends ReaderParser
implements HttpPartParser,
UonMetaProvider,
UonCommon {
    static final String PREFIX = "UonParser";
    public static final String UON_decoding = "UonParser.decoding.b";
    public static final String UON_validateEnd = "UonParser.validateEnd.b";
    public static final UonParser DEFAULT = new UonParser(PropertyStore.DEFAULT);
    public static final UonParser DEFAULT_DECODING = new Decoding(PropertyStore.DEFAULT);
    private final boolean decoding;
    private final boolean validateEnd;
    private final Map<ClassMeta<?>, UonClassMeta> uonClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, UonBeanPropertyMeta> uonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UonBeanPropertyMeta>();

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> toType) throws ParseException, SchemaValidationException {
        return this.createPartSession(null).parse(partType, schema, in, toType);
    }

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, Class<T> toType) throws ParseException, SchemaValidationException {
        return this.createPartSession(null).parse(partType, schema, in, this.getClassMeta(toType));
    }

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, Type toType, Type ... toTypeArgs) throws ParseException, SchemaValidationException {
        return this.createPartSession(null).parse(partType, schema, in, this.getClassMeta(toType, toTypeArgs));
    }

    public UonParser(PropertyStore ps) {
        this(ps, "text/uon");
    }

    public UonParser() {
        this(PropertyStore.DEFAULT, "text/uon");
    }

    public UonParser(PropertyStore ps, String ... consumes) {
        super(ps, consumes);
        this.decoding = this.getBooleanProperty(UON_decoding, false);
        this.validateEnd = this.getBooleanProperty(UON_validateEnd, false);
    }

    @Override
    public UonParserBuilder builder() {
        return new UonParserBuilder(this.getPropertyStore());
    }

    public static UonParserBuilder create() {
        return new UonParserBuilder();
    }

    protected final UonParserSession createParameterSession() {
        return new UonParserSession(this, this.createDefaultSessionArgs(), false);
    }

    @Override
    public UonParserSession createSession(ParserSessionArgs args) {
        return new UonParserSession(this, args);
    }

    @Override
    public UonParserSession createSession() {
        return this.createSession(null);
    }

    @Override
    public UonParserSession createPartSession(ParserSessionArgs args) {
        return new UonParserSession(this, args);
    }

    @Override
    public UonClassMeta getUonClassMeta(ClassMeta<?> cm) {
        UonClassMeta m = this.uonClassMetas.get(cm);
        if (m == null) {
            m = new UonClassMeta(cm, this);
            this.uonClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public UonBeanPropertyMeta getUonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UonBeanPropertyMeta.DEFAULT;
        }
        UonBeanPropertyMeta m = this.uonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.uonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final boolean isDecoding() {
        return this.decoding;
    }

    protected final boolean isValidateEnd() {
        return this.validateEnd;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("decoding", this.decoding).a("validateEnd", this.validateEnd));
    }

    public static class Decoding
    extends UonParser {
        public Decoding(PropertyStore ps) {
            super(ps.builder().setDefault(UonParser.UON_decoding, true).build());
        }
    }
}

