/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConstructor;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.reflect.ReflectFlags;
import org.apache.juneau.transform.BeanFilter;

public class BeanMeta<T> {
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final Map<String, BeanPropertyMeta> hiddenProperties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final ConstructorInfo constructor;
    protected final String[] constructorArgs;
    final String typePropertyName;
    private final BeanPropertyMeta typeProperty;
    final BeanPropertyMeta dynaProperty;
    private final String dictionaryName;
    final String notABeanReason;
    final BeanRegistry beanRegistry;
    final boolean sortProperties;
    final boolean fluentSetters;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder<T> b = new Builder<T>(classMeta, ctx, beanFilter, pNames);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = b.dictionaryName;
        this.properties = AMap.unmodifiable(b.properties);
        this.hiddenProperties = b.hiddenProperties.unmodifiable();
        this.getterProps = b.getterProps.unmodifiable();
        this.setterProps = b.setterProps.unmodifiable();
        this.dynaProperty = b.dynaProperty;
        this.typeVarImpls = AMap.unmodifiable(b.typeVarImpls);
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.beanRegistry = b.beanRegistry;
        this.typePropertyName = b.typePropertyName;
        this.typeProperty = BeanPropertyMeta.builder(this, this.typePropertyName).canRead().canWrite().rawMetaType(ctx.string()).beanRegistry(this.beanRegistry).build();
        this.sortProperties = b.sortProperties;
        this.fluentSetters = b.fluentSetters;
    }

    @BeanIgnore
    public final ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public final String getDictionaryName() {
        return this.dictionaryName;
    }

    public final BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    static final List<BeanMethod> findBeanMethods(BeanContext ctx, Class<?> c, Class<?> stopClass, Visibility v, PropertyNamer pn, boolean fluentSetters) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (MethodInfo m : c2.getDeclaredMethods()) {
                Transient t;
                BeanIgnore bi;
                if (m.isStatic() || m.isBridge() || m.getParamCount() > 2 || (bi = ctx.getLastAnnotation(BeanIgnore.class, m)) != null || (t = ctx.getLastAnnotation(Transient.class, m)) != null && t.value()) continue;
                BeanProperty px = m.getLastAnnotation(BeanProperty.class);
                List<Beanp> lp = ctx.getAnnotations(Beanp.class, m);
                List<Name> ln = ctx.getAnnotations(Name.class, m);
                if (!m.isVisible(v) && px == null && lp.size() <= 0 && ln.size() <= 0) continue;
                String n = m.getSimpleName();
                List<ClassInfo> pt = m.getParamTypes();
                ClassInfo rt = m.getReturnType();
                MethodType methodType = MethodType.UNKNOWN;
                String bpName = BeanMeta.bpName(px, lp, ln);
                if (pt.size() == 0) {
                    if ("*".equals(bpName)) {
                        if (rt.isChildOf(Collection.class)) {
                            methodType = MethodType.EXTRAKEYS;
                        } else if (rt.isChildOf(Map.class)) {
                            methodType = MethodType.GETTER;
                        }
                        n = bpName;
                    } else if (n.startsWith("get") && !rt.is(Void.TYPE)) {
                        methodType = MethodType.GETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.is(Boolean.TYPE) || rt.is(Boolean.class))) {
                        methodType = MethodType.GETTER;
                        n = n.substring(2);
                    } else if (bpName != null) {
                        methodType = MethodType.GETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            } else if (n.startsWith("is")) {
                                n = n.substring(2);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    }
                } else if (pt.size() == 1) {
                    if ("*".equals(bpName)) {
                        if (pt.get(0).isChildOf(Map.class)) {
                            methodType = MethodType.SETTER;
                            n = bpName;
                        } else if (pt.get(0).is(String.class)) {
                            methodType = MethodType.GETTER;
                            n = bpName;
                        }
                    } else if (n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE))) {
                        methodType = MethodType.SETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("with") && rt.isParentOf(c)) {
                        methodType = MethodType.SETTER;
                        n = n.substring(4);
                    } else if (bpName != null) {
                        methodType = MethodType.SETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("set")) {
                                n = n.substring(3);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    } else if (fluentSetters && rt.isParentOf(c)) {
                        methodType = MethodType.SETTER;
                    }
                } else if (pt.size() == 2 && "*".equals(bpName) && pt.get(0).is(String.class)) {
                    methodType = n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE)) ? MethodType.SETTER : MethodType.GETTER;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if ("*".equals(bpName) && methodType == MethodType.UNKNOWN) {
                    throw new BeanRuntimeException(c, "Found @Beanp(\"*\") but could not determine method type on method ''{0}''.", m.getSimpleName());
                }
                if (methodType == MethodType.UNKNOWN) continue;
                if (bpName != null && !bpName.isEmpty()) {
                    n = bpName;
                }
                if (n == null) continue;
                l.add(new BeanMethod(n, methodType, m.inner()));
            }
        }
        return l;
    }

    static final Collection<Field> findBeanFields(BeanContext ctx, Class<?> c, Class<?> stopClass, Visibility v) {
        LinkedList<Field> l = new LinkedList<Field>();
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (FieldInfo f : c2.getDeclaredFields()) {
                if (f.isAny(ReflectFlags.STATIC) || ctx.isIgnoreTransientFields() && f.isAny(ReflectFlags.TRANSIENT) || ctx.hasAnnotation(BeanIgnore.class, f)) continue;
                BeanProperty px = f.getAnnotation(BeanProperty.class);
                List<Beanp> lp = ctx.getAnnotations(Beanp.class, f);
                if (!v.isVisible(f.inner()) && px == null && lp.size() <= 0) continue;
                l.add(f.inner());
            }
        }
        return l;
    }

    static final Field findInnerBeanField(BeanContext bc, Class<?> c, Class<?> stopClass, String name) {
        for (ClassInfo c2 : BeanMeta.findClasses(c, stopClass)) {
            for (FieldInfo f : c2.getDeclaredFields()) {
                if (f.isAny(ReflectFlags.STATIC) || bc.isIgnoreTransientFields() && (f.isAny(ReflectFlags.TRANSIENT) || f.hasAnnotation(Transient.class)) || f.hasAnnotation(BeanIgnore.class, bc) || !f.hasName(name)) continue;
                return f.inner();
            }
        }
        return null;
    }

    private static List<ClassInfo> findClasses(Class<?> c, Class<?> stopClass) {
        LinkedList<ClassInfo> l = new LinkedList<ClassInfo>();
        BeanMeta.findClasses(c, l, stopClass);
        return l;
    }

    private static void findClasses(Class<?> c, LinkedList<ClassInfo> l, Class<?> stopClass) {
        while (c != null && stopClass != c) {
            l.addFirst(ClassInfo.of(c));
            for (Class<?> ci : c.getInterfaces()) {
                BeanMeta.findClasses(ci, l, stopClass);
            }
            c = c.getSuperclass();
        }
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return this.properties.values();
    }

    public Collection<BeanPropertyMeta> getPropertyMetas(String ... pNames) {
        if (pNames == null) {
            return this.getPropertyMetas();
        }
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(pNames.length);
        for (int i = 0; i < pNames.length; ++i) {
            l.add(this.getPropertyMeta(pNames[i]));
        }
        return l;
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.hiddenProperties.get(name);
        }
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    protected T newBean(Object outer) throws ExecutableException {
        if (this.classMeta.isMemberClass()) {
            if (this.constructor != null) {
                return this.constructor.invoke(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.invoke(null);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.innerClass.getClassLoader();
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    static final void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    public Object onReadProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.readProperty(bean, name, value);
    }

    public Object onWriteProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.writeProperty(bean, name, value);
    }

    static final String bpName(BeanProperty px, List<Beanp> p, List<Name> n) {
        if (px == null && p.isEmpty() && n.isEmpty()) {
            return null;
        }
        if (!n.isEmpty()) {
            return CollectionUtils.last(n).value();
        }
        String name = p.isEmpty() ? null : "";
        for (Beanp pp : p) {
            if (!pp.value().isEmpty()) {
                name = pp.value();
            }
            if (pp.name().isEmpty()) continue;
            name = pp.name();
        }
        if (name != null) {
            return name;
        }
        if (px != null) {
            if (!px.name().isEmpty()) {
                return px.name();
            }
            return px.value();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.properties.values()) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.classMeta.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof BeanMeta && ObjectUtils.eq(this, (BeanMeta)o, (x, y) -> ObjectUtils.eq(x.classMeta, y.classMeta));
    }

    private static final class BeanMethod {
        String propertyName;
        MethodType methodType;
        Method method;
        ClassInfo type;

        BeanMethod(String propertyName, MethodType type, Method method) {
            this.propertyName = propertyName;
            this.methodType = type;
            this.method = method;
            this.type = type == MethodType.SETTER ? ClassInfo.of(method.getParameterTypes()[0]) : ClassInfo.of(method.getReturnType());
        }

        boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (b.getter != null) {
                pt = b.getter.getReturnType();
            } else if (b.field != null) {
                pt = b.field.getType();
            }
            if (pt == null) {
                return true;
            }
            if (!this.type.isParentOf(pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            return this.type.isStrictChildOf(b.setter.getParameterTypes()[0]);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    static enum MethodType {
        UNKNOWN,
        GETTER,
        SETTER,
        EXTRAKEYS;

    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        AMap<String, BeanPropertyMeta> hiddenProperties = AMap.of();
        AMap<Method, String> getterProps = AMap.of();
        AMap<Method, String> setterProps = AMap.of();
        BeanPropertyMeta dynaProperty;
        AMap<Class<?>, Class<?>[]> typeVarImpls;
        ConstructorInfo constructor;
        String[] constructorArgs = new String[0];
        PropertyNamer propertyNamer;
        BeanRegistry beanRegistry;
        String dictionaryName;
        String typePropertyName;
        boolean sortProperties;
        boolean fluentSetters;

        Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
        }

        /*
         * WARNING - void declaration
         */
        String init(BeanMeta<T> beanMeta) {
            Class<T> c = this.classMeta.getInnerClass();
            ClassInfo ci = this.classMeta.getInfo();
            try {
                LinkedHashMap<String, BeanPropertyMeta> properties2;
                Object m;
                Set<String> bfbpi;
                String pn;
                boolean hasBeanIgnore;
                Class<Object> stopClass;
                Visibility conVis = this.ctx.getBeanConstructorVisibility();
                Visibility cVis = this.ctx.getBeanClassVisibility();
                Visibility mVis = this.ctx.getBeanMethodVisibility();
                Visibility fVis = this.ctx.getBeanFieldVisibility();
                AList<Class> bdClasses = AList.of();
                if (this.beanFilter != null && this.beanFilter.getBeanDictionary() != null) {
                    bdClasses.a(this.beanFilter.getBeanDictionary());
                }
                boolean hasTypeName = false;
                for (Bean b : this.classMeta.getAnnotations(Bean.class)) {
                    if (b.typeName().isEmpty()) continue;
                    hasTypeName = true;
                }
                if (hasTypeName) {
                    bdClasses.add(this.classMeta.innerClass);
                }
                this.beanRegistry = new BeanRegistry(this.ctx, null, bdClasses.toArray(new Class[bdClasses.size()]));
                for (Bean b : this.classMeta.getAnnotations(Bean.class)) {
                    if (b.typePropertyName().isEmpty()) continue;
                    this.typePropertyName = b.typePropertyName();
                }
                if (this.typePropertyName == null) {
                    this.typePropertyName = this.ctx.getBeanTypePropertyName();
                }
                this.fluentSetters = this.ctx.isFluentSetters() || this.beanFilter != null && this.beanFilter.isFluentSetters();
                Class<T> c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta.Builder> normalProps = new LinkedHashMap<String, BeanPropertyMeta.Builder>();
                Annotation ba = ci.getAnyLastAnnotation(this.ctx, Bean.class, BeanIgnore.class);
                boolean hasBean = ba != null && ba.annotationType() == Bean.class;
                boolean bl = hasBeanIgnore = ba != null && ba.annotationType() == BeanIgnore.class;
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!(hasBean || cVis.isVisible(c.getModifiers()) || c.isAnonymousClass())) {
                    return "Class is not public";
                }
                if (hasBeanIgnore) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSerializable() && !ci.isChildOf(Serializable.class)) {
                    return "Class is not serializable";
                }
                for (ConstructorInfo x : ci.getPublicConstructors()) {
                    if (x.hasAnnotation(BeanConstructor.class)) {
                        if (this.constructor != null) {
                            throw new BeanRuntimeException(c, "Multiple instances of '@BeanConstructor' found.", new Object[0]);
                        }
                        this.constructor = x;
                        this.constructorArgs = StringUtils.split(x.getAnnotation(BeanConstructor.class).properties());
                        if (this.constructorArgs.length != x.getParamCount()) {
                            if (this.constructorArgs.length != 0) {
                                throw new BeanRuntimeException(c, "Number of properties defined in '@BeanConstructor' annotation does not match number of parameters in constructor.", new Object[0]);
                            }
                            this.constructorArgs = new String[x.getParamCount()];
                            int i = 0;
                            for (ParamInfo pi2 : x.getParams()) {
                                pn = pi2.getName();
                                if (pn == null) {
                                    throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                                }
                                this.constructorArgs[i++] = pn;
                            }
                        }
                        this.constructor.setAccessible();
                    }
                    if (!this.ctx.hasAnnotation(Beanc.class, x)) continue;
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@Beanc' found.", new Object[0]);
                    }
                    this.constructor = x;
                    this.constructorArgs = new String[0];
                    for (Beanc beanc : this.ctx.getAnnotations(Beanc.class, x)) {
                        if (beanc.properties().isEmpty()) continue;
                        this.constructorArgs = StringUtils.split(beanc.properties());
                    }
                    if (this.constructorArgs.length != x.getParamCount()) {
                        if (this.constructorArgs.length != 0) {
                            throw new BeanRuntimeException(c, "Number of properties defined in '@Beanc' annotation does not match number of parameters in constructor.", new Object[0]);
                        }
                        this.constructorArgs = new String[x.getParamCount()];
                        int i = 0;
                        for (ParamInfo pi : x.getParams()) {
                            pn = pi.getName();
                            if (pn == null) {
                                throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                            }
                            this.constructorArgs[i++] = pn;
                        }
                    }
                    this.constructor.setAccessible();
                }
                if (this.constructor == null) {
                    for (ConstructorInfo x : ci.getDeclaredConstructors()) {
                        if (!this.ctx.hasAnnotation(Beanc.class, x)) continue;
                        if (this.constructor != null) {
                            throw new BeanRuntimeException(c, "Multiple instances of '@Beanc' found.", new Object[0]);
                        }
                        this.constructor = x;
                        this.constructorArgs = new String[0];
                        for (Beanc beanc : this.ctx.getAnnotations(Beanc.class, x)) {
                            if (beanc.properties().isEmpty()) continue;
                            this.constructorArgs = StringUtils.split(beanc.properties());
                        }
                        if (this.constructorArgs.length != x.getParamCount()) {
                            if (this.constructorArgs.length != 0) {
                                throw new BeanRuntimeException(c, "Number of properties defined in '@Beanc' annotation does not match number of parameters in constructor.", new Object[0]);
                            }
                            this.constructorArgs = new String[x.getParamCount()];
                            int i = 0;
                            for (ParamInfo pi : x.getParams()) {
                                pn = pi.getName();
                                if (pn == null) {
                                    throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                                }
                                this.constructorArgs[i++] = pn;
                            }
                        }
                        this.constructor.setAccessible();
                    }
                }
                if (this.constructor == null) {
                    this.constructor = this.ctx.getImplClassConstructor(c, conVis);
                }
                if (this.constructor == null) {
                    this.constructor = ci.getNoArgConstructor(hasBean ? Visibility.PRIVATE : conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.isBeansRequireDefaultConstructor()) {
                    return "Class does not have the required no-arg constructor";
                }
                if (this.constructor != null) {
                    this.constructor.setAccessible();
                }
                LinkedHashSet<String> fixedBeanProps = new LinkedHashSet<String>();
                LinkedHashSet<String> bpi = new LinkedHashSet<String>(this.ctx.getBpi(c));
                LinkedHashSet<String> bpx = new LinkedHashSet<String>(this.ctx.getBpx(c));
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.ctx.getBpro(c));
                LinkedHashSet<String> bpwo = new LinkedHashSet<String>(this.ctx.getBpwo(c));
                HashSet<String> filterProps = new HashSet<String>();
                if (this.beanFilter != null) {
                    bfbpi = this.beanFilter.getBpi();
                    filterProps.addAll(bfbpi);
                    if (bpi.isEmpty()) {
                        fixedBeanProps.addAll(bfbpi);
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                    linkedHashSet.addAll(this.beanFilter.getBpro());
                    bpwo.addAll(this.beanFilter.getBpwo());
                }
                fixedBeanProps.addAll(bpi);
                if (this.propertyNamer == null) {
                    this.propertyNamer = this.ctx.getPropertyNamer();
                }
                for (String string : fixedBeanProps) {
                    normalProps.put(string, BeanPropertyMeta.builder(beanMeta, string));
                }
                if (this.ctx.isUseJavaBeanIntrospector()) {
                    Object bi = null;
                    bi = !c2.isInterface() ? Introspector.getBeanInfo(c2, stopClass) : Introspector.getBeanInfo(c2, null);
                    if (bi != null) {
                        void var25_65;
                        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
                        int n = propertyDescriptorArray.length;
                        boolean bl2 = false;
                        while (var25_65 < n) {
                            PropertyDescriptor pd = propertyDescriptorArray[var25_65];
                            String name2 = pd.getName();
                            if (!normalProps.containsKey(name2)) {
                                normalProps.put(name2, BeanPropertyMeta.builder(beanMeta, name2));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name2)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                            ++var25_65;
                        }
                    }
                } else {
                    for (Field field : BeanMeta.findBeanFields(this.ctx, c2, stopClass, fVis)) {
                        String name = this.findPropertyName(field);
                        if (name == null) continue;
                        if (!normalProps.containsKey(name)) {
                            normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                        }
                        ((BeanPropertyMeta.Builder)normalProps.get(name)).setField(field);
                    }
                    List<BeanMethod> bms = BeanMeta.findBeanMethods(this.ctx, c2, stopClass, mVis, this.propertyNamer, this.fluentSetters);
                    for (BeanMethod bm : bms) {
                        String string = bm.propertyName;
                        m = bm.method;
                        if (!normalProps.containsKey(string)) {
                            normalProps.put(string, new BeanPropertyMeta.Builder(beanMeta, string));
                        }
                        BeanPropertyMeta.Builder bpm2 = (BeanPropertyMeta.Builder)normalProps.get(string);
                        if (bm.methodType != MethodType.GETTER) continue;
                        if (bpm2.getter != null) {
                            if (((Method)m).getAnnotation(BeanProperty.class) == null && bpm2.getter.getAnnotation(BeanProperty.class) != null) {
                                m = bpm2.getter;
                            } else if (!this.ctx.hasAnnotation(Beanp.class, (Method)m) && this.ctx.hasAnnotation(Beanp.class, bpm2.getter)) {
                                m = bpm2.getter;
                            } else if (((Method)m).getName().startsWith("is") && bpm2.getter.getName().startsWith("get")) {
                                m = bpm2.getter;
                            }
                        }
                        bpm2.setGetter((Method)m);
                    }
                    for (BeanMethod bm : bms) {
                        BeanPropertyMeta.Builder builder;
                        if (bm.methodType != MethodType.SETTER || !bm.matchesPropertyType(builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName))) continue;
                        builder.setSetter(bm.method);
                    }
                    for (BeanMethod bm : bms) {
                        if (bm.methodType != MethodType.EXTRAKEYS) continue;
                        BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName);
                        builder.setExtraKeys(bm.method);
                    }
                }
                this.typeVarImpls = AMap.of();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                Iterator<Object> i = normalProps.values().iterator();
                while (i.hasNext()) {
                    BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)i.next();
                    try {
                        if (builder.field == null) {
                            builder.setInnerField(BeanMeta.findInnerBeanField(this.ctx, c, stopClass, builder.name));
                        }
                        if (builder.validate(this.ctx, this.beanRegistry, this.typeVarImpls, linkedHashSet, bpwo)) {
                            if (builder.getter != null) {
                                this.getterProps.put(builder.getter, builder.name);
                            }
                            if (builder.setter == null) continue;
                            this.setterProps.put(builder.setter, builder.name);
                            continue;
                        }
                        i.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                for (String string : fixedBeanProps) {
                    if (normalProps.containsKey(string)) continue;
                    throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(bpi=X) annotation of class ''{1}'' but was not found on the class definition.", string, ci.getSimpleName());
                }
                for (Iterator<Object> iterator : this.constructorArgs) {
                    m = (BeanPropertyMeta.Builder)normalProps.get(iterator);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Beanc(properties=X) annotation but was not found on the class definition.", iterator);
                    }
                    ((BeanPropertyMeta.Builder)m).setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSomeProperties() && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                this.sortProperties = (this.ctx.isSortProperties() || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                this.properties = this.sortProperties ? new TreeMap<String, BeanPropertyMeta>() : new LinkedHashMap<String, BeanPropertyMeta>();
                if (this.beanFilter != null && this.beanFilter.getTypeName() != null) {
                    this.dictionaryName = this.beanFilter.getTypeName();
                }
                if (this.dictionaryName == null) {
                    this.dictionaryName = this.findDictionaryName(this.classMeta);
                }
                for (Map.Entry entry : normalProps.entrySet()) {
                    BeanPropertyMeta pMeta = ((BeanPropertyMeta.Builder)entry.getValue()).build();
                    if (pMeta.isDyna()) {
                        this.dynaProperty = pMeta;
                    }
                    this.properties.put((String)entry.getKey(), pMeta);
                }
                if (this.beanFilter != null) {
                    bfbpi = this.beanFilter.getBpi();
                    Set<String> set = this.beanFilter.getBpx();
                    if (bpi.isEmpty() && !bfbpi.isEmpty()) {
                        LinkedHashMap<String, BeanPropertyMeta> properties22 = new LinkedHashMap<String, BeanPropertyMeta>();
                        for (String k : bfbpi) {
                            if (!this.properties.containsKey(k)) continue;
                            properties22.put(k, this.properties.remove(k));
                        }
                        this.hiddenProperties.putAll(this.properties);
                        this.properties = properties22;
                    }
                    if (bpx.isEmpty() && !set.isEmpty()) {
                        for (String string : set) {
                            this.hiddenProperties.put(string, this.properties.remove(string));
                        }
                    }
                }
                if (!bpi.isEmpty()) {
                    properties2 = new LinkedHashMap();
                    for (String k : bpi) {
                        if (!this.properties.containsKey(k)) continue;
                        properties2.put(k, this.properties.remove(k));
                    }
                    this.hiddenProperties.putAll(this.properties);
                    this.properties = properties2;
                }
                for (String string : bpx) {
                    this.hiddenProperties.put(string, this.properties.remove(string));
                }
                if (this.pNames != null) {
                    void var25_75;
                    properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                    String[] stringArray = this.pNames;
                    int n = stringArray.length;
                    boolean bl3 = false;
                    while (var25_75 < n) {
                        String k;
                        k = stringArray[var25_75];
                        if (this.properties.containsKey(k)) {
                            properties2.put(k, this.properties.get(k));
                        } else {
                            this.hiddenProperties.put(k, this.properties.get(k));
                        }
                        ++var25_75;
                    }
                    this.properties = properties2;
                }
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + StringUtils.getStackTrace(e);
            }
            return null;
        }

        private String findDictionaryName(ClassMeta<?> cm) {
            String s;
            String s2;
            BeanRegistry br = cm.getBeanRegistry();
            if (br != null && (s2 = br.getTypeName(this.classMeta)) != null) {
                return s2;
            }
            Class pcm = cm.innerClass.getSuperclass();
            if (pcm != null && (s = this.findDictionaryName(this.ctx.getClassMeta(pcm))) != null) {
                return s;
            }
            for (Class<?> icm : cm.innerClass.getInterfaces()) {
                String s3 = this.findDictionaryName(this.ctx.getClassMeta(icm));
                if (s3 == null) continue;
                return s3;
            }
            return null;
        }

        private String findPropertyName(Field f) {
            List<Name> ln;
            List<Beanp> lp;
            BeanProperty px = f.getAnnotation(BeanProperty.class);
            String name = BeanMeta.bpName(px, lp = this.ctx.getAnnotations(Beanp.class, f), ln = this.ctx.getAnnotations(Name.class, f));
            if (StringUtils.isNotEmpty(name)) {
                return name;
            }
            return this.propertyNamer.getPropertyName(f.getName());
        }
    }
}

