/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.internal.HashCode;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.SwaggerGenerator;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.svl.VarResolverSession;

public class BasicRestInfoProvider
implements RestInfoProvider {
    private final RestContext context;
    private final String siteName;
    private final String title;
    private final String description;
    private final ConcurrentHashMap<Locale, ConcurrentHashMap<Integer, Swagger>> swaggers = new ConcurrentHashMap();

    public BasicRestInfoProvider(RestContext context) {
        this.context = context;
        Builder b = new Builder(context);
        this.siteName = b.siteName;
        this.title = b.title;
        this.description = b.description;
    }

    @Override
    public Swagger getSwagger(RestRequest req) throws Exception {
        Swagger swagger;
        Locale locale = req.getLocale();
        HashCode userHash = HashCode.create();
        for (RestMethodContext sm : this.context.getMethodContexts()) {
            if (!sm.isRequestAllowed(req)) continue;
            userHash.add(sm.hashCode());
        }
        int hashCode = userHash.get();
        if (!this.swaggers.containsKey(locale)) {
            this.swaggers.putIfAbsent(locale, new ConcurrentHashMap());
        }
        if ((swagger = this.swaggers.get(locale).get(hashCode)) != null) {
            return swagger;
        }
        swagger = new SwaggerGenerator(req.getContext(), req.getVarResolverSession(), req.getLocale()).getSwagger();
        this.swaggers.get(locale).put(hashCode, swagger);
        return swagger;
    }

    @Override
    public String getMethodSummary(Method method, RestRequest req) throws Exception {
        Operation o;
        VarResolverSession vr = req.getVarResolverSession();
        String s = ((RestMethod)MethodInfo.of((Method)method).getLastAnnotation(RestMethod.class)).summary();
        if (s.isEmpty() && (o = this.getSwaggerOperation(method, req)) != null) {
            s = o.getSummary();
        }
        return StringUtils.isEmpty((String)s) ? null : vr.resolve(s);
    }

    @Override
    public String getMethodDescription(Method method, RestRequest req) throws Exception {
        Operation o;
        VarResolverSession vr = req.getVarResolverSession();
        String s = BasicRestInfoProvider.joinnl(((RestMethod)MethodInfo.of((Method)method).getLastAnnotation(RestMethod.class)).description());
        if (s.isEmpty() && (o = this.getSwaggerOperation(method, req)) != null) {
            s = o.getDescription();
        }
        return StringUtils.isEmpty((String)s) ? null : vr.resolve(s);
    }

    @Override
    public String getSiteName(RestRequest req) throws Exception {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.siteName != null) {
            return vr.resolve(this.siteName);
        }
        String siteName = this.context.getMessages().forLocale(req.getLocale()).findFirstString(new String[]{"siteName"});
        if (siteName != null) {
            return vr.resolve(siteName);
        }
        return null;
    }

    @Override
    public String getTitle(RestRequest req) throws Exception {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.title != null) {
            return vr.resolve(this.title);
        }
        String title = this.context.getMessages().forLocale(req.getLocale()).findFirstString(new String[]{"title"});
        if (title != null) {
            return vr.resolve(title);
        }
        return null;
    }

    @Override
    public String getDescription(RestRequest req) throws Exception {
        VarResolverSession vr = req.getVarResolverSession();
        if (this.description != null) {
            return vr.resolve(this.description);
        }
        String description = this.context.getMessages().forLocale(req.getLocale()).findFirstString(new String[]{"description"});
        if (description != null) {
            return vr.resolve(description);
        }
        return null;
    }

    private Operation getSwaggerOperation(Method method, RestRequest req) throws Exception {
        Map spp;
        Map sp;
        Swagger s = this.getSwagger(req);
        if (s != null && (sp = s.getPaths()) != null && (spp = (Map)sp.get(RestUtils.fixMethodPath((String)((RestMethod)MethodInfo.of((Method)method).getLastAnnotation(RestMethod.class)).path()))) != null) {
            return (Operation)spp.get(req.getMethod());
        }
        return null;
    }

    static String joinnl(String[] ss) {
        if (ss.length == 0) {
            return "";
        }
        return StringUtils.joinnl((Object[])ss).trim();
    }

    private static final class Builder {
        String siteName;
        String title;
        String description;

        Builder(RestContext context) {
            ClassInfo ci = ClassInfo.of((Object)context.getResource()).resolved();
            for (RestResource r : ci.getAnnotations(RestResource.class)) {
                if (!r.siteName().isEmpty()) {
                    this.siteName = r.siteName();
                }
                if (r.title().length > 0) {
                    this.title = BasicRestInfoProvider.joinnl(r.title());
                }
                if (r.description().length <= 0) continue;
                this.description = BasicRestInfoProvider.joinnl(r.description());
            }
            for (RestResource r : ci.getAnnotations(Rest.class)) {
                if (!r.siteName().isEmpty()) {
                    this.siteName = r.siteName();
                }
                if (r.title().length > 0) {
                    this.title = BasicRestInfoProvider.joinnl(r.title());
                }
                if (r.description().length <= 0) continue;
                this.description = BasicRestInfoProvider.joinnl(r.description());
            }
        }
    }
}

