/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.johnzon.mapper.MappingGenerator;

public class DynamicMappingGenerator
implements MappingGenerator {
    private final MappingGenerator delegate;
    private final Runnable writeStart;
    private final Runnable writeEnd;
    private final String keyName;
    private InObjectOrPrimitiveJsonGenerator generator;

    public DynamicMappingGenerator(MappingGenerator delegate, Runnable writeStart, Runnable writeEnd, String keyName) {
        this.delegate = delegate;
        this.writeStart = writeStart;
        this.writeEnd = writeEnd;
        this.keyName = keyName;
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        return this.generator == null ? (this.generator = new InObjectOrPrimitiveJsonGenerator(this.delegate.getJsonGenerator(), this.writeStart, this.keyName)) : this.generator;
    }

    @Override
    public MappingGenerator writeObject(String key, Object o, JsonGenerator generator) {
        return this.delegate.writeObject(key, o, this.ensureGenerator(generator));
    }

    @Override
    public MappingGenerator writeObject(Object o, JsonGenerator generator) {
        return this.delegate.writeObject(o, this.ensureGenerator(generator));
    }

    private JsonGenerator ensureGenerator(JsonGenerator generator) {
        if (this.generator != null && this.generator != generator && this.generator.delegate != generator) {
            this.generator = null;
        }
        return this.getJsonGenerator();
    }

    public void flushIfNeeded() {
        if (this.generator.state == WritingState.WROTE_START_OBJECT) {
            this.writeEnd.run();
            this.generator.state = WritingState.NONE;
        }
    }

    private static class InObjectOrPrimitiveJsonGenerator
    implements JsonGenerator {
        private final JsonGenerator delegate;
        private final Runnable writeStart;
        private final String keyIfNoObject;
        private WritingState state = WritingState.NONE;

        private InObjectOrPrimitiveJsonGenerator(JsonGenerator generator, Runnable writeStart, String keyName) {
            this.delegate = generator;
            this.writeStart = writeStart;
            this.keyIfNoObject = keyName;
        }

        private void ensureStart() {
            if (this.state == WritingState.WROTE_START_OBJECT) {
                return;
            }
            this.writeStart.run();
            this.state = WritingState.WROTE_START_OBJECT;
        }

        public JsonGenerator writeStartObject() {
            return this.delegate.writeStartObject();
        }

        public JsonGenerator writeStartObject(String name) {
            this.ensureStart();
            return this.delegate.writeStartObject(name);
        }

        public JsonGenerator writeStartArray() {
            if (this.keyIfNoObject != null && this.state == WritingState.NONE) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.writeStartArray(this.keyIfNoObject);
            }
            return this.delegate.writeStartArray();
        }

        public JsonGenerator writeStartArray(String name) {
            this.ensureStart();
            return this.delegate.writeStartArray(name);
        }

        public JsonGenerator writeKey(String name) {
            this.ensureStart();
            return this.delegate.writeKey(name);
        }

        public JsonGenerator write(String name, JsonValue value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, String value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, BigInteger value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, BigDecimal value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, int value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, long value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, double value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator write(String name, boolean value) {
            this.ensureStart();
            return this.delegate.write(name, value);
        }

        public JsonGenerator writeNull(String name) {
            this.ensureStart();
            return this.delegate.writeNull(name);
        }

        public JsonGenerator writeEnd() {
            return this.delegate.writeEnd();
        }

        public JsonGenerator write(JsonValue value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(String value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(BigDecimal value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(BigInteger value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(int value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(long value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(double value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator write(boolean value) {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.write(this.keyIfNoObject, value);
            }
            return this.delegate.write(value);
        }

        public JsonGenerator writeNull() {
            if (this.isWritingPrimitive()) {
                this.state = WritingState.DONT_WRITE_END;
                return this.delegate.writeNull(this.keyIfNoObject);
            }
            return this.delegate.writeNull();
        }

        private boolean isWritingPrimitive() {
            return this.state == WritingState.NONE && this.keyIfNoObject != null;
        }

        public void close() {
            this.delegate.close();
        }

        public void flush() {
            this.delegate.flush();
        }
    }

    private static enum WritingState {
        NONE,
        WROTE_START_OBJECT,
        DONT_WRITE_END;

    }
}

