/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.WindowUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public final class ToolTipUtil {
    public static void applyContext(JToolTip toolTip) {
        JComponent target = toolTip.getComponent();
        if (target == null) {
            return;
        }
        ToolTipContext context = ToolTipUtil.getToolTipContext(toolTip);
        if (context == null) {
            return;
        }
        context.setTarget(target);
        context.setToolTip(toolTip);
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, target);
        Point pos = ToolTipUtil.getBestPositionMatch(context, p);
        if (pos != null) {
            ToolTipUtil.moveToolTip(toolTip, pos.x, pos.y, target);
        }
    }

    protected static Point getBestPositionMatch(ToolTipContext context, Point p) {
        if (!context.isBestFit()) {
            return context.getToolTipLocation(p, null);
        }
        Rectangle screenBounds = DarkUIUtil.getScreenBounds(context.getTarget(), p);
        Rectangle windowBounds = DarkUIUtil.getWindow(context.getTarget()).getBounds();
        Rectangle tooltipBounds = new Rectangle();
        tooltipBounds.setSize(context.getToolTip().getPreferredSize());
        Alignment original = context.getAlignment();
        Alignment originalCenter = context.getCenterAlignment();
        boolean isCenter = original == Alignment.CENTER;
        Alignment targetAlignment = isCenter ? originalCenter : original;
        boolean centerVertically = targetAlignment.isHorizontal();
        boolean centerHorizontally = targetAlignment.isVertical();
        Alignment[] alignments = ToolTipUtil.getAlignments(targetAlignment);
        BiConsumer<ToolTipContext, Alignment> setter = isCenter ? ToolTipContext::setCenterAlignment : ToolTipContext::setAlignment;
        Point pos = ToolTipUtil.tryAlignments(alignments, context, p, tooltipBounds, windowBounds, screenBounds, setter, centerHorizontally, centerVertically);
        if (pos == null) {
            pos = ToolTipUtil.tryAlignments(alignments, context, p, tooltipBounds, screenBounds, screenBounds, setter, centerHorizontally, centerVertically);
        }
        if (pos == null) {
            context.setAlignment(Alignment.CENTER);
            context.setCenterAlignment(Alignment.CENTER);
            pos = context.getFallBackPosition();
        }
        context.updateToolTip();
        context.setAlignment(original);
        context.setCenterAlignment(originalCenter);
        return pos;
    }

    protected static Point tryAlignments(Alignment[] alignments, ToolTipContext context, Point p, Rectangle tooltipBounds, Rectangle boundary, Rectangle screenBoundary, BiConsumer<ToolTipContext, Alignment> setter, boolean centerHorizontally, boolean centerVertically) {
        Point pos = null;
        for (Alignment a : alignments) {
            if ((centerHorizontally || centerVertically) && a.isDiagonal() && (pos = ToolTipUtil.tryPosition(a, context, p, tooltipBounds, boundary, screenBoundary, setter, centerHorizontally, centerVertically)) != null || (pos = ToolTipUtil.tryPosition(a, context, p, tooltipBounds, boundary, screenBoundary, setter, false, false)) != null) break;
        }
        return pos;
    }

    protected static Alignment[] getAlignments(Alignment start) {
        return new Alignment[]{start, start.opposite(), start.clockwise().clockwise(), start.anticlockwise().anticlockwise(), start.clockwise(), start.clockwise().opposite(), start.anticlockwise(), start.anticlockwise().opposite()};
    }

    protected static Point tryPosition(Alignment a, ToolTipContext context, Point p, Rectangle tooltipBounds, Rectangle boundary, Rectangle screenBoundary, BiConsumer<ToolTipContext, Alignment> setter, boolean centerHorizontally, boolean centerVertically) {
        setter.accept(context, a);
        context.setCenterAlignment(a);
        context.updateToolTip();
        Point pos = context.getToolTipLocation(p, null, centerHorizontally, centerVertically);
        Point screenPos = new Point(pos.x, pos.y);
        SwingUtilities.convertPointToScreen(screenPos, context.getTarget());
        tooltipBounds.setLocation(screenPos);
        if (!ToolTipUtil.fits(tooltipBounds, boundary, screenBoundary)) {
            pos = null;
        }
        return pos;
    }

    protected static boolean fits(Rectangle toolTipBounds, Rectangle boundary, Rectangle screenBoundary) {
        if (boundary == screenBoundary) {
            return SwingUtilities.isRectangleContainingRectangle(boundary, toolTipBounds);
        }
        return SwingUtilities.isRectangleContainingRectangle(boundary, toolTipBounds) && SwingUtilities.isRectangleContainingRectangle(screenBoundary, toolTipBounds);
    }

    protected static ToolTipContext getToolTipContext(JToolTip tooltip) {
        Object context = tooltip.getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        context = tooltip.getComponent().getClientProperty("JToolTip.toolTipContext");
        if (context instanceof ToolTipContext) {
            return (ToolTipContext)context;
        }
        Object style = tooltip.getComponent().getClientProperty("JToolTip.style");
        if (ToolTipStyle.BALLOON.equals(ToolTipStyle.parse(style))) {
            return ToolTipContext.getDefaultContext();
        }
        return null;
    }

    public static void moveToolTip(JToolTip toolTip, int x, int y, JComponent target) {
        Window window = DarkUIUtil.getWindow(toolTip);
        if (window == null) {
            return;
        }
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, target);
        WindowUtil.moveWindow(window, toolTip, p.x, p.y);
    }
}

