/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.smtp.sampler.protocol.SendMailCommand;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpSampler
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final Logger log = LoggerFactory.getLogger(SmtpSampler.class);
    public static final String SERVER = "SMTPSampler.server";
    public static final String SERVER_PORT = "SMTPSampler.serverPort";
    public static final String SERVER_TIMEOUT = "SMTPSampler.serverTimeout";
    public static final String SERVER_CONNECTION_TIMEOUT = "SMTPSampler.serverConnectionTimeout";
    public static final String USE_AUTH = "SMTPSampler.useAuth";
    public static final String USERNAME = "SMTPSampler.username";
    public static final String PASSWORD = "SMTPSampler.password";
    public static final String MAIL_FROM = "SMTPSampler.mailFrom";
    public static final String MAIL_REPLYTO = "SMTPSampler.replyTo";
    public static final String RECEIVER_TO = "SMTPSampler.receiverTo";
    public static final String RECEIVER_CC = "SMTPSampler.receiverCC";
    public static final String RECEIVER_BCC = "SMTPSampler.receiverBCC";
    public static final String SUBJECT = "SMTPSampler.subject";
    public static final String SUPPRESS_SUBJECT = "SMTPSampler.suppressSubject";
    public static final String MESSAGE = "SMTPSampler.message";
    public static final String PLAIN_BODY = "SMTPSampler.plainBody";
    public static final String INCLUDE_TIMESTAMP = "SMTPSampler.include_timestamp";
    public static final String ATTACH_FILE = "SMTPSampler.attachFile";
    public static final String MESSAGE_SIZE_STATS = "SMTPSampler.messageSizeStatistics";
    public static final String HEADER_FIELDS = "SMTPSampler.headerFields";
    public static final String USE_EML = "SMTPSampler.use_eml";
    public static final String EML_MESSAGE_TO_SEND = "SMTPSampler.emlMessageToSend";
    public static final String ENABLE_DEBUG = "SMTPSampler.enableDebug";
    public static final String FILENAME_SEPARATOR = ";";

    public SampleResult sample(Entry e) {
        Message message;
        SendMailCommand sendMailCmd;
        SampleResult result = this.createSampleResult();
        try {
            sendMailCmd = this.createSendMailCommandFromProperties();
            message = sendMailCmd.prepareMessage();
            result.setBytes(this.calculateMessageSize(message));
        }
        catch (Exception ex) {
            log.warn("Error while preparing message", (Throwable)ex);
            result.setResponseCode("500");
            result.setResponseMessage(ex.toString());
            return result;
        }
        result.setDataType("text");
        try {
            result.setRequestHeaders(SmtpSampler.getRequestHeaders(message));
            result.setSamplerData(SmtpSampler.getSamplerData(message));
        }
        catch (IOException | MessagingException ex) {
            result.setSamplerData("Error occurred trying to save request info: " + ex);
            log.warn("Error occurred trying to save request info", ex);
        }
        result.sampleStart();
        boolean isSuccessful = SmtpSampler.executeMessage(result, sendMailCmd, message);
        result.sampleEnd();
        try {
            result.setResponseData(SmtpSampler.processSampler(message));
        }
        catch (IOException | MessagingException ex) {
            log.warn("Failed to set result response data", ex);
        }
        result.setSuccessful(isSuccessful);
        return result;
    }

    private SampleResult createSampleResult() {
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        return result;
    }

    private static boolean executeMessage(SampleResult result, SendMailCommand sendMailCmd, Message message) {
        boolean didSampleSucceed = false;
        try {
            sendMailCmd.execute(message);
            result.setResponseCodeOK();
            result.setResponseMessage("Message successfully sent!\n");
            didSampleSucceed = true;
        }
        catch (AuthenticationFailedException afex) {
            log.warn("", (Throwable)afex);
            result.setResponseCode("500");
            result.setResponseMessage("AuthenticationFailedException: authentication failed - wrong username / password!\n" + (Object)((Object)afex));
        }
        catch (Exception ex) {
            log.warn("", (Throwable)ex);
            result.setResponseCode("500");
            result.setResponseMessage(ex.getMessage());
        }
        return didSampleSucceed;
    }

    private long calculateMessageSize(Message message) throws IOException, MessagingException {
        if (this.getPropertyAsBoolean(MESSAGE_SIZE_STATS)) {
            CountingOutputStream cs = new CountingOutputStream((OutputStream)NullOutputStream.INSTANCE);
            message.writeTo((OutputStream)cs);
            return cs.getByteCount();
        }
        return -1L;
    }

    private static byte[] processSampler(Message message) throws IOException, MessagingException {
        try (InputStream is = message.getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    private List<File> getAttachmentFiles() {
        String[] attachments = this.getPropertyAsString(ATTACH_FILE).split(FILENAME_SEPARATOR);
        return Arrays.stream(attachments).filter(s -> !s.isEmpty()).map(SmtpSampler::attachmentToFile).collect(Collectors.toList());
    }

    private static File attachmentToFile(String attachment) {
        File file = new File(attachment);
        if (!file.isAbsolute() && !file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug("loading file with relative path: " + attachment);
            }
            file = new File(FileServer.getFileServer().getBaseDir(), attachment);
            if (log.isDebugEnabled()) {
                log.debug("file path set to: " + attachment);
            }
        }
        return file;
    }

    private String calculateSubject() {
        if (this.getPropertyAsBoolean(SUPPRESS_SUBJECT)) {
            return null;
        }
        String subject = this.getPropertyAsString(SUBJECT);
        if (this.getPropertyAsBoolean(INCLUDE_TIMESTAMP)) {
            subject = subject + " <<< current timestamp: " + System.currentTimeMillis() + " >>>";
        }
        return subject;
    }

    private SendMailCommand createSendMailCommandFromProperties() throws AddressException {
        SendMailCommand sendMailCmd = new SendMailCommand();
        sendMailCmd.setSmtpServer(this.getPropertyAsString(SERVER));
        sendMailCmd.setSmtpPort(this.getPropertyAsString(SERVER_PORT));
        sendMailCmd.setConnectionTimeOut(this.getPropertyAsString(SERVER_CONNECTION_TIMEOUT));
        sendMailCmd.setTimeOut(this.getPropertyAsString(SERVER_TIMEOUT));
        sendMailCmd.setUseSSL(this.getPropertyAsBoolean("SMTPSampler.useSSL"));
        sendMailCmd.setUseStartTLS(this.getPropertyAsBoolean("SMTPSampler.useStartTLS"));
        sendMailCmd.setTrustAllCerts(this.getPropertyAsBoolean("SMTPSampler.trustAllCerts"));
        sendMailCmd.setEnforceStartTLS(this.getPropertyAsBoolean("SMTPSampler.enforceStartTLS"));
        sendMailCmd.setTlsProtocolsToUse(this.getPropertyAsString("SMTPSampler.tlsProtocols"));
        sendMailCmd.setUseAuthentication(this.getPropertyAsBoolean(USE_AUTH));
        sendMailCmd.setUsername(this.getPropertyAsString(USERNAME));
        sendMailCmd.setPassword(this.getPropertyAsString(PASSWORD));
        sendMailCmd.setUseLocalTrustStore(this.getPropertyAsBoolean("SMTPSampler.useLocalTrustStore"));
        sendMailCmd.setTrustStoreToUse(this.getPropertyAsString("SMTPSampler.trustStoreToUse"));
        sendMailCmd.setEmlMessage(this.getPropertyAsString(EML_MESSAGE_TO_SEND));
        sendMailCmd.setUseEmlMessage(this.getPropertyAsBoolean(USE_EML));
        if (!this.getPropertyAsBoolean(USE_EML)) {
            sendMailCmd.setMailBody(this.getPropertyAsString(MESSAGE));
            sendMailCmd.setPlainBody(this.getPropertyAsBoolean(PLAIN_BODY));
            this.getAttachmentFiles().forEach(sendMailCmd::addAttachment);
        }
        sendMailCmd.setEnableDebug(this.getPropertyAsBoolean(ENABLE_DEBUG));
        if (this.getPropertyAsString(MAIL_FROM).matches(".*@.*")) {
            sendMailCmd.setSender(SmtpSampler.encodeAddress(this.getPropertyAsString(MAIL_FROM)));
        }
        sendMailCmd.setReceiverTo(this.getPropAsAddresses(RECEIVER_TO));
        sendMailCmd.setReceiverCC(this.getPropAsAddresses(RECEIVER_CC));
        sendMailCmd.setReceiverBCC(this.getPropAsAddresses(RECEIVER_BCC));
        sendMailCmd.setReplyTo(this.getPropAsAddresses(MAIL_REPLYTO));
        sendMailCmd.setSubject(this.calculateSubject());
        sendMailCmd.setSynchronousMode(true);
        sendMailCmd.setHeaderFields((CollectionProperty)this.getProperty(HEADER_FIELDS));
        return sendMailCmd;
    }

    private static String getRequestHeaders(Message message) throws MessagingException {
        StringBuilder sb = new StringBuilder();
        Enumeration headers = message.getAllHeaders();
        SmtpSampler.writeHeaders(headers, sb);
        return sb.toString();
    }

    private static String getSamplerData(Message message) throws MessagingException, IOException {
        StringBuilder sb = new StringBuilder();
        Object content = message.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            String contentType = multipart.getContentType();
            ContentType ct = new ContentType(contentType);
            String boundary = ct.getParameter("boundary");
            for (int i = 0; i < multipart.getCount(); ++i) {
                sb.append("--");
                sb.append(boundary);
                sb.append("\n");
                BodyPart bodyPart = multipart.getBodyPart(i);
                SmtpSampler.writeBodyPart(sb, bodyPart);
            }
            sb.append("--");
            sb.append(boundary);
            sb.append("--");
            sb.append("\n");
        } else if (content instanceof BodyPart) {
            BodyPart bodyPart = (BodyPart)content;
            SmtpSampler.writeBodyPart(sb, bodyPart);
        } else if (content instanceof String) {
            sb.append(content);
        } else {
            sb.append("Content has class: ");
            sb.append(content.getClass().getCanonicalName());
        }
        return sb.toString();
    }

    private static void writeHeaders(Enumeration<? extends Header> headers, StringBuilder sb) {
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            sb.append(header.getName());
            sb.append(": ");
            sb.append(header.getValue());
            sb.append("\n");
        }
    }

    private static void writeBodyPart(StringBuilder sb, BodyPart bodyPart) throws MessagingException, IOException {
        Enumeration allHeaders = bodyPart.getAllHeaders();
        SmtpSampler.writeHeaders(allHeaders, sb);
        String disposition = bodyPart.getDisposition();
        sb.append("\n");
        if ("attachment".equals(disposition)) {
            sb.append("<attachment content not shown>");
        } else {
            sb.append(bodyPart.getContent());
        }
        sb.append("\n");
    }

    private List<InternetAddress> getPropAsAddresses(String propKey) throws AddressException {
        String propValue = this.getPropertyAsString(propKey).trim();
        if (!propValue.isEmpty()) {
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
            for (String address : propValue.split(FILENAME_SEPARATOR)) {
                addresses.add(new InternetAddress(SmtpSampler.encodeAddress(address)));
            }
            return addresses;
        }
        return null;
    }

    private static String encodeAddress(String address) {
        String trimmedAddress = address.trim();
        if (!StringUtils.isAsciiPrintable((CharSequence)trimmedAddress)) {
            try {
                int startOfRealAddress = trimmedAddress.indexOf(60);
                if (startOfRealAddress >= 0) {
                    String personalPart = trimmedAddress.substring(0, startOfRealAddress);
                    return MimeUtility.encodeWord((String)personalPart) + trimmedAddress.substring(startOfRealAddress);
                }
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Can't encode [{}] as quoted printable", (Object)trimmedAddress, (Object)e);
            }
        }
        return trimmedAddress;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

