/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.cassandra.components.CassandraQuotaCurrentValueDao;
import org.apache.james.backends.cassandra.components.CassandraQuotaLimitDao;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaCurrentValue;
import org.apache.james.core.quota.QuotaLimit;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaType;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraSieveQuotaDAOV2
implements CassandraSieveQuotaDAO {
    public static final QuotaComponent QUOTA_COMPONENT = QuotaComponent.of((String)"SIEVE");
    public static final String GLOBAL = "GLOBAL";
    private final CassandraQuotaCurrentValueDao currentValueDao;
    private final CassandraQuotaLimitDao limitDao;

    @Inject
    public CassandraSieveQuotaDAOV2(CassandraQuotaCurrentValueDao currentValueDao, CassandraQuotaLimitDao limitDao) {
        this.currentValueDao = currentValueDao;
        this.limitDao = limitDao;
    }

    @Override
    public Mono<Long> spaceUsedBy(Username username) {
        QuotaCurrentValue.Key quotaKey = this.asQuotaKey(username);
        return this.currentValueDao.getQuotaCurrentValue(quotaKey).map(QuotaCurrentValue::getCurrentValue).switchIfEmpty(Mono.just((Object)0L));
    }

    private QuotaCurrentValue.Key asQuotaKey(Username username) {
        return QuotaCurrentValue.Key.of((QuotaComponent)QUOTA_COMPONENT, (String)username.asString(), (QuotaType)QuotaType.SIZE);
    }

    @Override
    public Mono<Void> updateSpaceUsed(Username username, long spaceUsed) {
        QuotaCurrentValue.Key quotaKey = this.asQuotaKey(username);
        return this.currentValueDao.deleteQuotaCurrentValue(quotaKey).then(this.currentValueDao.increase(quotaKey, spaceUsed));
    }

    @Override
    public Mono<Optional<QuotaSizeLimit>> getQuota() {
        return this.limitDao.getQuotaLimits(QUOTA_COMPONENT, QuotaScope.GLOBAL, GLOBAL).map(v -> v.getQuotaLimit().map(QuotaSizeLimit::size)).switchIfEmpty((Publisher)Mono.just(Optional.empty())).single();
    }

    @Override
    public Mono<Void> setQuota(QuotaSizeLimit quota) {
        return this.limitDao.setQuotaLimit(QuotaLimit.builder().quotaComponent(QUOTA_COMPONENT).quotaScope(QuotaScope.GLOBAL).quotaType(QuotaType.SIZE).identifier(GLOBAL).quotaLimit(Long.valueOf(quota.asLong())).build());
    }

    @Override
    public Mono<Void> removeQuota() {
        return this.limitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QUOTA_COMPONENT, (QuotaScope)QuotaScope.GLOBAL, (String)GLOBAL, (QuotaType)QuotaType.SIZE));
    }

    @Override
    public Mono<Optional<QuotaSizeLimit>> getQuota(Username username) {
        return this.limitDao.getQuotaLimits(QUOTA_COMPONENT, QuotaScope.USER, username.asString()).map(v -> v.getQuotaLimit().map(QuotaSizeLimit::size)).switchIfEmpty((Publisher)Mono.just(Optional.empty())).single();
    }

    @Override
    public Mono<Void> setQuota(Username username, QuotaSizeLimit quota) {
        return this.limitDao.setQuotaLimit(QuotaLimit.builder().quotaComponent(QUOTA_COMPONENT).quotaScope(QuotaScope.USER).quotaType(QuotaType.SIZE).identifier(username.asString()).quotaLimit(Long.valueOf(quota.asLong())).build());
    }

    @Override
    public Mono<Void> removeQuota(Username username) {
        return this.limitDao.deleteQuotaLimit(QuotaLimit.QuotaLimitKey.of((QuotaComponent)QUOTA_COMPONENT, (QuotaScope)QuotaScope.USER, (String)username.asString(), (QuotaType)QuotaType.SIZE));
    }

    @Override
    public Mono<Void> resetSpaceUsed(Username username, long spaceUsed) {
        return this.spaceUsedBy(username).flatMap(currentSpace -> this.currentValueDao.increase(this.asQuotaKey(username), spaceUsed - currentSpace));
    }
}

