/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.message.request.AbstractImapRequest;
import org.apache.james.mailbox.model.UidValidity;

public abstract class AbstractMailboxSelectionRequest
extends AbstractImapRequest {
    private final String mailboxName;
    private final boolean condstore;
    private final ClientSpecifiedUidValidity lastKnownUidValidity;
    private final Long knownModSeq;
    private final UidRange[] uidSet;
    private final UidRange[] knownUidSet;
    private final IdRange[] knownSequenceSet;

    public AbstractMailboxSelectionRequest(ImapCommand command, String mailboxName, boolean condstore, ClientSpecifiedUidValidity lastKnownUidValidity, Long knownModSeq, UidRange[] uidSet, UidRange[] knownUidSet, IdRange[] knownSequenceSet, Tag tag) {
        super(tag, command);
        this.mailboxName = mailboxName;
        this.condstore = condstore;
        this.lastKnownUidValidity = lastKnownUidValidity;
        this.knownModSeq = knownModSeq;
        if (lastKnownUidValidity.isUnknown() && knownModSeq != null || !lastKnownUidValidity.isUnknown() && knownModSeq == null) {
            throw new IllegalArgumentException();
        }
        this.uidSet = uidSet;
        this.knownUidSet = knownUidSet;
        this.knownSequenceSet = knownSequenceSet;
    }

    public final String getMailboxName() {
        return this.mailboxName;
    }

    public final boolean getCondstore() {
        return this.condstore;
    }

    public final ClientSpecifiedUidValidity getLastKnownUidValidity() {
        return this.lastKnownUidValidity;
    }

    public final Long getKnownModSeq() {
        return this.knownModSeq;
    }

    public final UidRange[] getUidSet() {
        return this.uidSet;
    }

    public final IdRange[] getKnownSequenceSet() {
        return this.knownSequenceSet;
    }

    public final UidRange[] getKnownUidSet() {
        return this.knownUidSet;
    }

    public static interface ClientSpecifiedUidValidity {
        public static final ClientSpecifiedUidValidity UNKNOWN = new ClientSpecifiedUidValidity(){

            @Override
            public boolean isUnknown() {
                return true;
            }

            @Override
            public boolean correspondsTo(UidValidity uidValidity) {
                return false;
            }

            public String toString() {
                return "UidValidity{UNKNOWN}";
            }
        };

        public static ClientSpecifiedUidValidity of(long value) {
            if (UidValidity.isValid((long)value)) {
                return ClientSpecifiedUidValidity.valid(UidValidity.of((long)value));
            }
            return ClientSpecifiedUidValidity.invalid(value);
        }

        public static ClientSpecifiedUidValidity invalid(long invalidValue) {
            return new Invalid(invalidValue);
        }

        public static ClientSpecifiedUidValidity valid(UidValidity uidValidity) {
            return new Valid(uidValidity);
        }

        public boolean isUnknown();

        public boolean correspondsTo(UidValidity var1);

        public static class Invalid
        implements ClientSpecifiedUidValidity {
            private final long invalidUidValidity;

            public Invalid(long invalidUidValidity) {
                Preconditions.checkArgument((!UidValidity.isValid((long)invalidUidValidity) ? 1 : 0) != 0, (Object)"Need to supply an invalid value");
                this.invalidUidValidity = invalidUidValidity;
            }

            @Override
            public boolean isUnknown() {
                return false;
            }

            @Override
            public boolean correspondsTo(UidValidity uidValidity) {
                return false;
            }

            public final boolean equals(Object o) {
                if (o instanceof Invalid) {
                    Invalid invalid = (Invalid)o;
                    return Objects.equals(this.invalidUidValidity, invalid.invalidUidValidity);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.invalidUidValidity);
            }

            public String toString() {
                return String.format("Invalid UidValidity{%d}", this.invalidUidValidity);
            }
        }

        public static class Valid
        implements ClientSpecifiedUidValidity {
            private final UidValidity uidValidity;

            public Valid(UidValidity uidValidity) {
                this.uidValidity = uidValidity;
            }

            @Override
            public boolean isUnknown() {
                return false;
            }

            @Override
            public boolean correspondsTo(UidValidity uidValidity) {
                return this.uidValidity.equals((Object)uidValidity);
            }

            public final boolean equals(Object o) {
                if (o instanceof Valid) {
                    Valid valid = (Valid)o;
                    return Objects.equals(this.uidValidity, valid.uidValidity);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.uidValidity);
            }

            public String toString() {
                return String.format("UidValidity{%d}", this.uidValidity.asLong());
            }
        }
    }
}

