/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.delivery.MailStore;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class MailDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailDispatcher.class);
    private static final String[] NO_HEADERS = new String[0];
    public static final int RETRIES = 3;
    private static final Duration FIRST_BACKOFF = Duration.ofMillis(200L);
    private static final Duration MAX_BACKOFF = Duration.ofSeconds(1L);
    private final MailStore mailStore;
    private final MailetContext mailetContext;
    private final boolean consume;
    private final boolean ignoreError;
    private final boolean propagate;
    private final Optional<Integer> retries;
    private final String errorProcessor;

    public static Builder builder() {
        return new Builder();
    }

    private MailDispatcher(MailStore mailStore, MailetContext mailetContext, boolean consume, Optional<Integer> retries, String onMailetException) {
        this.mailStore = mailStore;
        this.consume = consume;
        this.mailetContext = mailetContext;
        this.retries = retries;
        this.errorProcessor = onMailetException;
        this.ignoreError = onMailetException.equalsIgnoreCase("ignore");
        this.propagate = onMailetException.equalsIgnoreCase("propagate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Mail mail) throws MessagingException {
        List<MailAddress> errors = this.customizeHeadersAndDeliver(mail);
        if (!errors.isEmpty() && !this.ignoreError) {
            MailImpl newMail = MailImpl.builder().name("error-" + mail.getName()).sender(mail.getMaybeSender()).addRecipients(errors).mimeMessage(mail.getMessage()).state(this.errorProcessor).build();
            try {
                this.mailetContext.sendMail((Mail)newMail);
            }
            finally {
                LifecycleUtil.dispose((Object)newMail);
            }
        }
        if (this.consume) {
            mail.setState("ghost");
        }
    }

    private List<MailAddress> customizeHeadersAndDeliver(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        message.setHeader("Return-Path", mail.getMaybeSender().asPrettyString());
        return this.deliver(mail, message);
    }

    private List<MailAddress> deliver(Mail mail, MimeMessage message) {
        return (List)Flux.fromIterable((Iterable)mail.getRecipients()).concatMap(recipient -> Mono.using(() -> this.saveHeaders(mail, (MailAddress)recipient), (Function)Throwing.function(any -> {
            this.addSpecificHeadersForRecipient(mail, message, (MailAddress)recipient);
            return this.storeMailWithRetry(mail, (MailAddress)recipient).then(Mono.empty());
        }), (Consumer)Throwing.consumer(savedHeaders -> this.restoreHeaders(mail.getMessage(), (Map<String, List<String>>)savedHeaders))).onErrorResume(ex -> {
            LOGGER.error("Error while storing mail. This is a final exception.", ex);
            if (this.propagate) {
                return Mono.error((Throwable)ex);
            }
            return Mono.just((Object)recipient);
        })).collectList().block();
    }

    private Mono<Void> storeMailWithRetry(Mail mail, MailAddress recipient) {
        AtomicInteger remainRetries = new AtomicInteger(this.retries.orElse(0));
        Mono operation = Mono.from(this.mailStore.storeMail(recipient, mail)).doOnError(error -> LOGGER.warn("Error While storing mail. This error will be retried for {} more times.", (Object)remainRetries.getAndDecrement(), error));
        return this.retries.map(count -> operation.retryWhen((Retry)Retry.backoff((long)count.intValue(), (Duration)FIRST_BACKOFF).maxBackoff(MAX_BACKOFF).scheduler(Schedulers.parallel())).then()).orElse(operation);
    }

    private Map<String, List<String>> saveHeaders(Mail mail, MailAddress recipient) throws MessagingException {
        ImmutableMap.Builder backup = ImmutableMap.builder();
        Collection headersToSave = mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(recipient);
        for (String headerName : headersToSave) {
            ImmutableList values = ImmutableList.copyOf((Object[])Optional.ofNullable(mail.getMessage().getHeader(headerName)).orElse(NO_HEADERS));
            backup.put((Object)headerName, (Object)values);
        }
        return backup.build();
    }

    private void restoreHeaders(MimeMessage mimeMessage, Map<String, List<String>> savedHeaders) throws MessagingException {
        for (Map.Entry<String, List<String>> header : savedHeaders.entrySet()) {
            String name = header.getKey();
            mimeMessage.removeHeader(name);
            for (String value : header.getValue()) {
                mimeMessage.addHeader(name, value);
            }
        }
    }

    private void addSpecificHeadersForRecipient(Mail mail, MimeMessage message, MailAddress recipient) throws MessagingException {
        for (PerRecipientHeaders.Header header : mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient)) {
            message.addHeader(header.getName(), header.getValue());
        }
    }

    public static class Builder {
        static final boolean DEFAULT_CONSUME = true;
        static final String DEFAULT_ERROR_PROCESSOR = "error";
        private MailStore mailStore;
        private Boolean consume;
        private MailetContext mailetContext;
        private String onMailetException;
        private Optional<Integer> retries = Optional.empty();

        public Builder consume(boolean consume) {
            this.consume = consume;
            return this;
        }

        public Builder mailStore(MailStore mailStore) {
            this.mailStore = mailStore;
            return this;
        }

        public Builder mailetContext(MailetContext mailetContext) {
            this.mailetContext = mailetContext;
            return this;
        }

        public Builder onMailetException(String onMailetException) {
            this.onMailetException = onMailetException;
            return this;
        }

        public Builder retries(int retries) {
            if (retries > 0) {
                this.retries = Optional.of(retries);
            }
            return this;
        }

        public MailDispatcher build() {
            Preconditions.checkNotNull((Object)this.mailStore);
            Preconditions.checkNotNull((Object)this.mailetContext);
            return new MailDispatcher(this.mailStore, this.mailetContext, Optional.ofNullable(this.consume).orElse(true), this.retries, Optional.ofNullable(this.onMailetException).orElse(DEFAULT_ERROR_PROCESSOR));
        }
    }
}

