/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.fetchmail.FetchMail;
import org.apache.james.fetchmail.FetchSchedulerMBean;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.concurrent.JMXEnabledScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchScheduler
implements FetchSchedulerMBean,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchScheduler.class);
    private HierarchicalConfiguration<ImmutableNode> conf;
    private volatile boolean enabled = false;
    private final List<ScheduledFuture<?>> schedulers = new ArrayList();
    private DNSService dns;
    private UsersRepository urepos;
    private MailQueueFactory<?> queueFactory;
    private DomainList domainList;
    private MailQueue queue;

    @Inject
    public void setMailQueueFactory(MailQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Inject
    public void setUsersRepository(UsersRepository urepos) {
        this.urepos = urepos;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public final void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        this.conf = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.enabled = this.conf.getBoolean("[@enabled]", false);
        if (this.enabled) {
            int numThreads = this.conf.getInt("threads", 5);
            String jmxName = this.conf.getString("jmxName", "fetchmail");
            String jmxPath = "org.apache.james:type=component,name=" + jmxName + ",sub-type=threadpool";
            JMXEnabledScheduledThreadPoolExecutor scheduler = new JMXEnabledScheduledThreadPoolExecutor(numThreads, jmxPath, "scheduler");
            this.queue = this.queueFactory.createQueue(MailQueueFactory.SPOOL);
            List fetchConfs = this.conf.configurationsAt("fetch");
            for (HierarchicalConfiguration fetchConf : fetchConfs) {
                Long interval = fetchConf.getLong("interval");
                FetchMail fetcher = new FetchMail();
                fetcher.setDNSService(this.dns);
                fetcher.setUsersRepository(this.urepos);
                fetcher.setMailQueue(this.queue);
                fetcher.setDomainList(this.domainList);
                fetcher.configure((HierarchicalConfiguration<ImmutableNode>)fetchConf);
                this.schedulers.add(scheduler.scheduleWithFixedDelay(fetcher, 0L, interval, TimeUnit.MILLISECONDS));
            }
            LOGGER.info("FetchMail Started");
        } else {
            LOGGER.info("FetchMail Disabled");
        }
    }

    @PreDestroy
    public void dispose() throws IOException {
        if (this.enabled) {
            LOGGER.info("FetchMail dispose...");
            this.queue.close();
            for (ScheduledFuture<?> scheduler1 : this.schedulers) {
                scheduler1.cancel(false);
            }
            LOGGER.info("FetchMail ...dispose end");
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }
}

