/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BigInteger;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.GeneralNames;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import java.math.BigInteger;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuthorityKeyIdentifierExtension
extends X509CertificateExtension {
    @NotNull
    public static final OID AUTHORITY_KEY_IDENTIFIER_OID = new OID("2.5.29.35");
    private static final byte TYPE_KEY_IDENTIFIER = -128;
    private static final byte TYPE_AUTHORITY_CERT_ISSUER = -95;
    private static final byte TYPE_AUTHORITY_CERT_SERIAL_NUMBER = -126;
    private static final long serialVersionUID = 8913323557731547122L;
    @Nullable
    private final ASN1OctetString keyIdentifier;
    @Nullable
    private final BigInteger authorityCertSerialNumber;
    @Nullable
    private final GeneralNames authorityCertIssuer;

    AuthorityKeyIdentifierExtension(boolean isCritical, @Nullable ASN1OctetString keyIdentifier, @Nullable GeneralNames authorityCertIssuer, @Nullable BigInteger authorityCertSerialNumber) throws CertException {
        super(AUTHORITY_KEY_IDENTIFIER_OID, isCritical, AuthorityKeyIdentifierExtension.encodeValue(keyIdentifier, authorityCertIssuer, authorityCertSerialNumber));
        this.keyIdentifier = keyIdentifier;
        this.authorityCertIssuer = authorityCertIssuer;
        this.authorityCertSerialNumber = authorityCertSerialNumber;
    }

    AuthorityKeyIdentifierExtension(@NotNull X509CertificateExtension extension) throws CertException {
        super(extension);
        try {
            ASN1OctetString keyID = null;
            BigInteger serialNumber = null;
            GeneralNames generalNames = null;
            block7: for (ASN1Element element : ASN1Sequence.decodeAsSequence(extension.getValue()).elements()) {
                switch (element.getType()) {
                    case -128: {
                        keyID = element.decodeAsOctetString();
                        continue block7;
                    }
                    case -95: {
                        ASN1Element generalNamesElement = ASN1Element.decode(element.getValue());
                        generalNames = new GeneralNames(generalNamesElement);
                        continue block7;
                    }
                    case -126: {
                        serialNumber = element.decodeAsBigInteger().getBigIntegerValue();
                    }
                }
            }
            this.keyIdentifier = keyID;
            this.authorityCertIssuer = generalNames;
            this.authorityCertSerialNumber = serialNumber;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_AUTHORITY_KEY_ID_EXTENSION_CANNOT_PARSE.get(String.valueOf(extension), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static byte[] encodeValue(@Nullable ASN1OctetString keyIdentifier, @Nullable GeneralNames authorityCertIssuer, @Nullable BigInteger authorityCertSerialNumber) throws CertException {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        if (keyIdentifier != null) {
            elements.add(new ASN1OctetString(-128, keyIdentifier.getValue()));
        }
        if (authorityCertIssuer != null) {
            elements.add(new ASN1Element(-95, authorityCertIssuer.encode().encode()));
        }
        if (authorityCertSerialNumber != null) {
            elements.add(new ASN1BigInteger(-126, authorityCertSerialNumber));
        }
        return new ASN1Sequence(elements).encode();
    }

    @Nullable
    public ASN1OctetString getKeyIdentifier() {
        return this.keyIdentifier;
    }

    @Nullable
    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    @Nullable
    public BigInteger getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    @Override
    @NotNull
    public String getExtensionName() {
        return CertMessages.INFO_AUTHORITY_KEY_ID_EXTENSION_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AuthorityKeyIdentifierExtension(oid='");
        buffer.append(this.getOID());
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        if (this.keyIdentifier != null) {
            buffer.append(", keyIdentifierBytes='");
            StaticUtils.toHex(this.keyIdentifier.getValue(), ":", buffer);
            buffer.append('\'');
        }
        if (this.authorityCertIssuer != null) {
            buffer.append(", authorityCertIssuer=");
            this.authorityCertIssuer.toString(buffer);
        }
        if (this.authorityCertSerialNumber != null) {
            buffer.append(", authorityCertSerialNumber='");
            StaticUtils.toHex(this.authorityCertSerialNumber.toByteArray(), ":", buffer);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

