/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class RouterStubManager
implements Runnable,
RouterStub.CloseListener {
    protected final ConcurrentMap<RouterStub, Future<?>> futures = new ConcurrentHashMap();
    protected volatile List<RouterStub> stubs;
    protected final Set<Target> reconnect_list = new HashSet<Target>();
    protected final Protocol owner;
    protected final TimeScheduler timer;
    protected final String cluster_name;
    protected final Address local_addr;
    protected final String logical_name;
    protected final PhysicalAddress phys_addr;
    protected final long interval;
    protected boolean use_nio = true;
    protected Future<?> reconnector_task;
    protected final Log log;
    private SocketFactory socket_factory;

    public RouterStubManager(Protocol owner, String cluster_name, Address local_addr, String logical_name, PhysicalAddress phys_addr, long interval) {
        this.owner = owner;
        this.stubs = new ArrayList<RouterStub>();
        this.log = LogFactory.getLog(owner.getClass());
        this.timer = owner.getTransport().getTimer();
        this.cluster_name = cluster_name;
        this.local_addr = local_addr;
        this.logical_name = logical_name;
        this.phys_addr = phys_addr;
        this.interval = interval;
    }

    public static RouterStubManager emptyGossipClientStubManager(Protocol p) {
        return new RouterStubManager(p, null, null, null, null, 0L);
    }

    public RouterStubManager useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public void forEach(Consumer<RouterStub> action) {
        this.stubs.stream().filter(RouterStub::isConnected).forEach(action);
    }

    public void forAny(Consumer<RouterStub> action) {
        while (!this.stubs.isEmpty()) {
            RouterStub stub = Util.pickRandomElement(this.stubs);
            if (stub == null || !stub.isConnected()) continue;
            action.accept(stub);
            return;
        }
    }

    public RouterStub createAndRegisterStub(IpAddress local, IpAddress router_addr) {
        RouterStub stub = new RouterStub(local, router_addr, this.use_nio, this, this.socket_factory);
        RouterStub old_stub = this.unregisterStub(router_addr);
        if (old_stub != null) {
            old_stub.destroy();
        }
        this.add(stub);
        return stub;
    }

    public RouterStub unregisterStub(IpAddress router_addr) {
        RouterStub stub = this.find(router_addr);
        if (stub != null) {
            this.remove(stub);
        }
        return stub;
    }

    public void connectStubs() {
        for (RouterStub stub : this.stubs) {
            try {
                if (stub.isConnected()) continue;
                stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
            }
            catch (Throwable e) {
                this.moveStubToReconnects(stub);
            }
        }
    }

    public void disconnectStubs() {
        this.stopReconnector();
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.cluster_name, this.local_addr);
            }
            catch (Throwable throwable) {}
        }
    }

    public void destroyStubs() {
        this.stopReconnector();
        this.stubs.forEach(RouterStub::destroy);
        this.stubs.clear();
    }

    public String printStubs() {
        return Util.printListWithDelimiter(this.stubs, ", ");
    }

    public String printReconnectList() {
        return Util.printListWithDelimiter(this.reconnect_list, ", ");
    }

    public String print() {
        return String.format("Stubs: %s\nReconnect list: %s", this.printStubs(), this.printReconnectList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean empty;
        ArrayList<Target> tmp;
        Set<Target> set = this.reconnect_list;
        synchronized (set) {
            tmp = new ArrayList<Target>(this.reconnect_list);
        }
        for (Target t : tmp) {
            if (!this.reconnect(t)) continue;
            this.remove(t);
        }
        set = this.reconnect_list;
        synchronized (set) {
            empty = this.reconnect_list.isEmpty();
        }
        if (empty) {
            this.stopReconnector();
        }
    }

    @Override
    public void closed(RouterStub stub) {
        this.moveStubToReconnects(stub);
    }

    protected boolean reconnect(Target target) {
        RouterStub stub = new RouterStub(target.bind_addr, target.router_addr, this.use_nio, this, this.socket_factory).receiver(target.receiver);
        if (!this.add(stub)) {
            return false;
        }
        try {
            stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
            this.log.debug("%s: re-established connection to %s successfully for group %s", this.local_addr, stub.remote(), this.cluster_name);
            return true;
        }
        catch (Throwable t) {
            this.remove(stub);
            return false;
        }
    }

    protected void moveStubToReconnects(RouterStub stub) {
        if (stub == null) {
            return;
        }
        this.remove(stub);
        if (this.add(new Target(stub.local(), stub.remote(), stub.receiver()))) {
            this.log.debug("%s: connection to %s closed, trying to re-establish connection", this.local_addr, stub.remote());
            this.startReconnector();
        }
    }

    protected boolean add(RouterStub stub) {
        if (stub == null) {
            return false;
        }
        ArrayList<RouterStub> new_stubs = new ArrayList<RouterStub>(this.stubs);
        boolean retval = !new_stubs.contains(stub) && new_stubs.add(stub);
        this.stubs = new_stubs;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(Target target) {
        if (target == null) {
            return false;
        }
        Set<Target> set = this.reconnect_list;
        synchronized (set) {
            return this.reconnect_list.add(target);
        }
    }

    protected boolean remove(RouterStub stub) {
        if (stub == null) {
            return false;
        }
        stub.destroy();
        ArrayList<RouterStub> new_stubs = new ArrayList<RouterStub>(this.stubs);
        boolean retval = new_stubs.remove(stub);
        this.stubs = new_stubs;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Target target) {
        if (target == null) {
            return false;
        }
        Set<Target> set = this.reconnect_list;
        synchronized (set) {
            return this.reconnect_list.remove(target);
        }
    }

    protected RouterStub find(IpAddress router_addr) {
        for (RouterStub stub : this.stubs) {
            IpAddress addr = stub.gossipRouterAddress();
            if (!Objects.equals(addr, router_addr)) continue;
            return stub;
        }
        return null;
    }

    protected synchronized void startReconnector() {
        if (this.reconnector_task == null || this.reconnector_task.isDone()) {
            this.reconnector_task = this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconnector() {
        if (this.reconnector_task != null) {
            this.reconnector_task.cancel(true);
        }
    }

    public RouterStubManager socketFactory(SocketFactory socket_factory) {
        this.socket_factory = socket_factory;
        return this;
    }

    protected static class Target
    implements Comparator<Target>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final IpAddress bind_addr;
        protected final IpAddress router_addr;
        protected final RouterStub.StubReceiver receiver;

        public Target(IpAddress bind_addr, IpAddress router_addr, RouterStub.StubReceiver receiver) {
            this.bind_addr = bind_addr;
            this.router_addr = router_addr;
            this.receiver = receiver;
        }

        @Override
        public int compare(Target o1, Target o2) {
            return o1.router_addr.compareTo(o2.router_addr);
        }

        public int hashCode() {
            return this.router_addr.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.compare(this, (Target)obj) == 0;
        }

        public String toString() {
            return String.format("%s -> %s", this.bind_addr, this.router_addr);
        }
    }
}

