/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch.json;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.backends.opensearch.json.JsonpUtils;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;

public abstract class JsonpDeserializerBase<V>
implements JsonpDeserializer<V> {
    private final EnumSet<JsonParser.Event> acceptedEvents;
    private final EnumSet<JsonParser.Event> nativeEvents;
    static final JsonpDeserializer<String> STRING = new JsonpDeserializerBase<String>(EnumSet.of(JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE), EnumSet.of(JsonParser.Event.VALUE_STRING)){

        public String deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_TRUE) {
                return "true";
            }
            if (event == JsonParser.Event.VALUE_FALSE) {
                return "false";
            }
            return parser.getString();
        }
    };
    static final JsonpDeserializer<Integer> INTEGER = new JsonpDeserializerBase<Integer>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_NUMBER)){

        public Integer deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Integer.valueOf(parser.getString());
            }
            return parser.getInt();
        }
    };
    static final JsonpDeserializer<Boolean> BOOLEAN = new JsonpDeserializerBase<Boolean>(EnumSet.of(JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE)){

        public Boolean deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Boolean.parseBoolean(parser.getString());
            }
            return event == JsonParser.Event.VALUE_TRUE;
        }
    };
    static final JsonpDeserializer<Long> LONG = new JsonpDeserializerBase<Long>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_NUMBER)){

        public Long deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Long.valueOf(parser.getString());
            }
            return parser.getLong();
        }
    };
    static final JsonpDeserializer<Float> FLOAT = new JsonpDeserializerBase<Float>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_NUMBER)){

        public Float deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Float.valueOf(parser.getString());
            }
            return Float.valueOf(parser.getBigDecimal().floatValue());
        }
    };
    static final JsonpDeserializer<Double> DOUBLE = new JsonpDeserializerBase<Double>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_NUMBER)){

        public Double deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return parser.getBigDecimal().doubleValue();
        }
    };
    static final JsonpDeserializer<Double> DOUBLE_OR_NAN = new JsonpDeserializerBase<Double>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NULL), EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL)){

        public Double deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_NULL) {
                return Double.NaN;
            }
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return parser.getBigDecimal().doubleValue();
        }
    };
    static final JsonpDeserializer<Number> NUMBER = new JsonpDeserializerBase<Number>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING), EnumSet.of(JsonParser.Event.VALUE_NUMBER)){

        public Number deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return ((JsonNumber)parser.getValue()).numberValue();
        }
    };
    static final JsonpDeserializer<JsonValue> JSON_VALUE = new JsonpDeserializerBase<JsonValue>(EnumSet.allOf(JsonParser.Event.class)){

        public JsonValue deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            return parser.getValue();
        }
    };
    static final JsonpDeserializer<Void> VOID = new JsonpDeserializerBase<Void>(EnumSet.noneOf(JsonParser.Event.class)){

        public Void deserialize(JsonParser parser, JsonpMapper mapper) {
            throw new JsonParsingException("Void types should not have any value", parser.getLocation());
        }

        public Void deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            return this.deserialize(parser, mapper);
        }
    };

    protected JsonpDeserializerBase(EnumSet<JsonParser.Event> acceptedEvents) {
        this(acceptedEvents, acceptedEvents);
    }

    protected JsonpDeserializerBase(EnumSet<JsonParser.Event> acceptedEvents, EnumSet<JsonParser.Event> nativeEvents) {
        this.acceptedEvents = acceptedEvents;
        this.nativeEvents = nativeEvents;
    }

    protected static EnumSet<JsonParser.Event> allAcceptedEvents(JsonpDeserializer<?> ... deserializers) {
        EnumSet<JsonParser.Event> result = EnumSet.noneOf(JsonParser.Event.class);
        for (JsonpDeserializer<?> deserializer : deserializers) {
            EnumSet set = deserializer.acceptedEvents();
            result.addAll(set);
        }
        return result;
    }

    public EnumSet<JsonParser.Event> nativeEvents() {
        return this.nativeEvents;
    }

    public final EnumSet<JsonParser.Event> acceptedEvents() {
        return this.acceptedEvents;
    }

    public final boolean accepts(JsonParser.Event event) {
        return this.acceptedEvents.contains(event);
    }

    static class EnumMapDeserializer<K, V>
    extends JsonpDeserializerBase<Map<K, V>> {
        private final JsonpDeserializer<K> keyDeserializer;
        private final JsonpDeserializer<V> valueDeserializer;

        protected EnumMapDeserializer(JsonpDeserializer<K> keyDeserializer, JsonpDeserializer<V> valueDeserializer) {
            super(EnumSet.of(JsonParser.Event.START_OBJECT));
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
        }

        public Map<K, V> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                Object key = this.keyDeserializer.deserialize(parser, mapper, event);
                Object value = this.valueDeserializer.deserialize(parser, mapper);
                result.put(key, value);
            }
            return result;
        }
    }

    static class StringMapDeserializer<T>
    extends JsonpDeserializerBase<Map<String, T>> {
        private final JsonpDeserializer<T> itemDeserializer;

        protected StringMapDeserializer(JsonpDeserializer<T> itemDeserializer) {
            super(EnumSet.of(JsonParser.Event.START_OBJECT));
            this.itemDeserializer = itemDeserializer;
        }

        public Map<String, T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                String key = parser.getString();
                Object value = this.itemDeserializer.deserialize(parser, mapper);
                result.put(key, value);
            }
            return result;
        }
    }

    static class ArrayDeserializer<T>
    implements JsonpDeserializer<List<T>> {
        private final JsonpDeserializer<T> itemDeserializer;
        private EnumSet<JsonParser.Event> acceptedEvents;
        private static final EnumSet<JsonParser.Event> nativeEvents = EnumSet.of(JsonParser.Event.START_ARRAY);

        protected ArrayDeserializer(JsonpDeserializer<T> itemDeserializer) {
            this.itemDeserializer = itemDeserializer;
        }

        public EnumSet<JsonParser.Event> nativeEvents() {
            return nativeEvents;
        }

        public EnumSet<JsonParser.Event> acceptedEvents() {
            if (this.acceptedEvents == null) {
                this.acceptedEvents = EnumSet.of(JsonParser.Event.START_ARRAY);
                this.acceptedEvents.addAll(this.itemDeserializer.acceptedEvents());
            }
            return this.acceptedEvents;
        }

        public List<T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.START_ARRAY) {
                ArrayList<Object> result = new ArrayList<Object>();
                while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
                    JsonpUtils.ensureAccepts(this.itemDeserializer, parser, event);
                    result.add(this.itemDeserializer.deserialize(parser, mapper, event));
                }
                return result;
            }
            JsonpUtils.ensureAccepts(this.itemDeserializer, parser, event);
            return Collections.singletonList(this.itemDeserializer.deserialize(parser, mapper, event));
        }
    }

    static final class StringOrNullDeserializer
    extends JsonpDeserializerBase<String> {
        static final EnumSet<JsonParser.Event> nativeEvents = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NULL);
        static final EnumSet<JsonParser.Event> acceptedEvents = EnumSet.of(JsonParser.Event.KEY_NAME, new JsonParser.Event[]{JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_NULL});

        StringOrNullDeserializer() {
            super(acceptedEvents, nativeEvents);
        }

        public String deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_NULL) {
                return null;
            }
            if (event == JsonParser.Event.VALUE_TRUE) {
                return "true";
            }
            if (event == JsonParser.Event.VALUE_FALSE) {
                return "false";
            }
            return parser.getString();
        }
    }

    static final class IntOrNullDeserializer
    extends JsonpDeserializerBase<Integer> {
        static final EnumSet<JsonParser.Event> nativeEvents = EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL);
        static final EnumSet<JsonParser.Event> acceptedEvents = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL);
        private final int defaultValue;

        IntOrNullDeserializer(int defaultValue) {
            super(acceptedEvents, nativeEvents);
            this.defaultValue = defaultValue;
        }

        public Integer deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_NULL) {
                return this.defaultValue;
            }
            if (event == JsonParser.Event.VALUE_STRING) {
                return Integer.valueOf(parser.getString());
            }
            return parser.getInt();
        }
    }

    static final class DoubleOrNullDeserializer
    extends JsonpDeserializerBase<Double> {
        static final EnumSet<JsonParser.Event> nativeEvents = EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL);
        static final EnumSet<JsonParser.Event> acceptedEvents = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL);
        private final double defaultValue;

        DoubleOrNullDeserializer(double defaultValue) {
            super(acceptedEvents, nativeEvents);
            this.defaultValue = defaultValue;
        }

        public Double deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_NULL) {
                return this.defaultValue;
            }
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return parser.getBigDecimal().doubleValue();
        }
    }
}

