/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDaoUtil;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.mailet.Mail;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EnqueuedMailsDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectStatement;
    private final PreparedStatement selectBlobIdsStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteBucketStatement;
    private final BlobId.Factory blobFactory;
    private final TupleType userHeaderNameHeaderValueTriple;

    @Inject
    @VisibleForTesting
    public EnqueuedMailsDAO(CqlSession session, BlobId.Factory blobIdFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectStatement = this.prepareSelectFrom(session);
        this.insertStatement = this.prepareInsert(session);
        this.deleteBucketStatement = this.prepareDeleteBucket(session);
        this.selectBlobIdsStatement = this.prepareSelectBlobIds(session);
        this.blobFactory = blobIdFactory;
        this.userHeaderNameHeaderValueTriple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.TEXT, DataTypes.TEXT});
    }

    private PreparedStatement prepareSelectFrom(CqlSession session) {
        return session.prepare(((Select)((Select)((Select)QueryBuilder.selectFrom((String)"enqueuedMailsV4").all().whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).whereColumn("timeRangeStart").isEqualTo((Term)QueryBuilder.bindMarker((String)"timeRangeStart"))).whereColumn("bucketId").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketId"))).build());
    }

    private PreparedStatement prepareSelectBlobIds(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"enqueuedMailsV4").columns(new String[]{"headerBlobId", "bodyBlobId"}).build());
    }

    private PreparedStatement prepareDeleteBucket(CqlSession session) {
        return session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"enqueuedMailsV4").whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).whereColumn("timeRangeStart").isEqualTo((Term)QueryBuilder.bindMarker((String)"timeRangeStart"))).whereColumn("bucketId").isEqualTo((Term)QueryBuilder.bindMarker((String)"bucketId"))).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"enqueuedMailsV4").value("queueName", (Term)QueryBuilder.bindMarker((String)"queueName")).value("timeRangeStart", (Term)QueryBuilder.bindMarker((String)"timeRangeStart")).value("bucketId", (Term)QueryBuilder.bindMarker((String)"bucketId")).value("enqueueId", (Term)QueryBuilder.bindMarker((String)"enqueueId")).value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("headerBlobId", (Term)QueryBuilder.bindMarker((String)"headerBlobId")).value("bodyBlobId", (Term)QueryBuilder.bindMarker((String)"bodyBlobId")).value("enqueuedTime", (Term)QueryBuilder.bindMarker((String)"enqueuedTime")).value("state", (Term)QueryBuilder.bindMarker((String)"state")).value("sender", (Term)QueryBuilder.bindMarker((String)"sender")).value("recipients", (Term)QueryBuilder.bindMarker((String)"recipients")).value("attributes", (Term)QueryBuilder.bindMarker((String)"attributes")).value("errorMessage", (Term)QueryBuilder.bindMarker((String)"errorMessage")).value("remoteAddr", (Term)QueryBuilder.bindMarker((String)"remoteAddr")).value("remoteHost", (Term)QueryBuilder.bindMarker((String)"remoteHost")).value("lastUpdated", (Term)QueryBuilder.bindMarker((String)"lastUpdated")).value("perRecipientSpecificHeaders", (Term)QueryBuilder.bindMarker((String)"perRecipientSpecificHeaders")).build());
    }

    Mono<Void> insert(EnqueuedItemWithSlicingContext enqueuedItemWithSlicing) {
        EnqueuedItem enqueuedItem = enqueuedItemWithSlicing.getEnqueuedItem();
        EnqueuedItemWithSlicingContext.SlicingContext slicingContext = enqueuedItemWithSlicing.getSlicingContext();
        Mail mail = enqueuedItem.getMail();
        MimeMessagePartsId mimeMessagePartsId = enqueuedItem.getPartsId();
        BoundStatementBuilder statement = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.insertStatement.boundStatementBuilder(new Object[0]).setString("queueName", enqueuedItem.getMailQueueName().asString())).setInstant("timeRangeStart", slicingContext.getTimeRangeStart())).setInt("bucketId", slicingContext.getBucketId().getValue())).setInstant("enqueuedTime", enqueuedItem.getEnqueuedTime())).setUuid("enqueueId", enqueuedItem.getEnqueueId().asUUID())).setString("name", mail.getName())).setString("headerBlobId", mimeMessagePartsId.getHeaderBlobId().asString())).setString("bodyBlobId", mimeMessagePartsId.getBodyBlobId().asString())).setString("state", mail.getState())).setList("recipients", EnqueuedMailsDaoUtil.asStringList(mail.getRecipients()), String.class)).setString("remoteAddr", mail.getRemoteAddr())).setString("remoteHost", mail.getRemoteHost())).setMap("attributes", EnqueuedMailsDaoUtil.toRawAttributeMap(mail), String.class, ByteBuffer.class)).setList("perRecipientSpecificHeaders", EnqueuedMailsDaoUtil.toTupleList(this.userHeaderNameHeaderValueTriple, mail.getPerRecipientSpecificHeaders()), TupleValue.class);
        Optional.ofNullable(mail.getErrorMessage()).ifPresent(errorMessage -> statement.setString("errorMessage", mail.getErrorMessage()));
        Optional.ofNullable(mail.getLastUpdated()).map(Date::toInstant).ifPresent(lastUpdated -> statement.setInstant("lastUpdated", lastUpdated));
        mail.getMaybeSender().asOptional().map(MailAddress::asString).ifPresent(mailAddress -> statement.setString("sender", mailAddress));
        return this.executor.executeVoid((Statement)statement.build());
    }

    @VisibleForTesting
    public Flux<EnqueuedItemWithSlicingContext> selectEnqueuedMails(MailQueueName queueName, BucketedSlices.Slice slice, BucketedSlices.BucketId bucketId) {
        return this.executor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectStatement.bind(new Object[0]).setString("queueName", queueName.asString())).setInstant("timeRangeStart", slice.getStartSliceInstant())).setInt("bucketId", bucketId.getValue())).map(row -> EnqueuedMailsDaoUtil.toEnqueuedMail(row, this.blobFactory));
    }

    Mono<Void> deleteBucket(MailQueueName queueName, BucketedSlices.Slice slice, BucketedSlices.BucketId bucketId) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.deleteBucketStatement.bind(new Object[0]).setString("queueName", queueName.asString())).setInstant("timeRangeStart", slice.getStartSliceInstant())).setInt("bucketId", bucketId.getValue()));
    }

    Flux<BlobId> listBlobIds() {
        return this.executor.executeRows((Statement)this.selectBlobIdsStatement.bind(new Object[0])).flatMapIterable(row -> ImmutableList.of((Object)this.blobFactory.from(row.getString("headerBlobId")), (Object)this.blobFactory.from(row.getString("bodyBlobId"))));
    }
}

