/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.commands;

import java.util.List;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.dlp.eventsourcing.commands.ClearCommand;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ClearCommandHandler
implements CommandHandler<ClearCommand> {
    private final EventStore eventStore;

    public ClearCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public Class<ClearCommand> handledClass() {
        return ClearCommand.class;
    }

    public Publisher<List<? extends Event>> handle(ClearCommand clearCommand) {
        DLPAggregateId aggregateId = new DLPAggregateId(clearCommand.getDomain());
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(history -> DLPDomainConfiguration.load(aggregateId, history).clear());
    }
}

