/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.List;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.PermFailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DKIMCommon {
    private static final boolean DEEP_DEBUG = false;

    protected static void updateSignature(Signature signature, boolean relaxed, CharSequence header, String fv) throws SignatureException {
        if (relaxed) {
            signature.update(((Object)header).toString().toLowerCase().getBytes());
            signature.update(":".getBytes());
            String headerValue = fv.substring(fv.indexOf(58) + 1);
            headerValue = headerValue.replaceAll("\r\n[\t ]", " ");
            headerValue = headerValue.replaceAll("[\t ]+", " ");
            headerValue = headerValue.trim();
            signature.update(headerValue.getBytes());
        } else {
            signature.update(fv.getBytes());
        }
    }

    protected static void signatureCheck(Headers h, SignatureRecord sign, List<CharSequence> headers, Signature signature) throws SignatureException, PermFailException {
        boolean relaxedHeaders = "relaxed".equals(sign.getHeaderCanonicalisationMethod());
        if (!relaxedHeaders && !"simple".equals(sign.getHeaderCanonicalisationMethod())) {
            throw new PermFailException("Unsupported canonicalization algorythm: " + sign.getHeaderCanonicalisationMethod());
        }
        HashMap<String, Integer> processedHeader = new HashMap<String, Integer>();
        for (CharSequence header : headers) {
            int doneHeaders;
            List<String> hl = h.getFields(((Object)header).toString());
            if (hl == null || hl.size() <= 0) continue;
            Integer done = (Integer)processedHeader.get(((Object)header).toString());
            if (done == null) {
                done = 0;
            }
            if ((doneHeaders = done + 1) > hl.size()) continue;
            String fv = hl.get(hl.size() - doneHeaders);
            DKIMCommon.updateSignature(signature, relaxedHeaders, header, fv);
            signature.update("\r\n".getBytes());
            processedHeader.put(((Object)header).toString(), new Integer(doneHeaders));
        }
        String signatureStub = "DKIM-Signature:" + sign.toUnsignedString();
        DKIMCommon.updateSignature(signature, relaxedHeaders, "dkim-signature", signatureStub);
    }

    public static void streamCopy(InputStream bodyIs, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[2048];
        while ((read = bodyIs.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        bodyIs.close();
        out.close();
    }
}

