/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.SockaddrIn;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

final class QuicheSendInfo {
    private static final FastThreadLocal<byte[]> IPV4_ARRAYS = new FastThreadLocal<byte[]>(){

        protected byte[] initialValue() {
            return new byte[4];
        }
    };
    private static final FastThreadLocal<byte[]> IPV6_ARRAYS = new FastThreadLocal<byte[]>(){

        protected byte[] initialValue() {
            return new byte[16];
        }
    };

    private QuicheSendInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InetSocketAddress getAddress(ByteBuffer memory) {
        int position = memory.position();
        try {
            long len = QuicheSendInfo.getLen(memory, position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO_LEN);
            memory.position(position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO);
            if (len == (long)Quiche.SIZEOF_SOCKADDR_IN) {
                InetSocketAddress inetSocketAddress = SockaddrIn.getIPv4(memory, (byte[])IPV4_ARRAYS.get());
                return inetSocketAddress;
            }
            assert (len == (long)Quiche.SIZEOF_SOCKADDR_IN6);
            InetSocketAddress inetSocketAddress = SockaddrIn.getIPv6(memory, (byte[])IPV6_ARRAYS.get(), (byte[])IPV4_ARRAYS.get());
            return inetSocketAddress;
        }
        finally {
            memory.position(position);
        }
    }

    private static long getLen(ByteBuffer memory, int index) {
        switch (Quiche.SIZEOF_SOCKLEN_T) {
            case 1: {
                return memory.get(index);
            }
            case 2: {
                return memory.getShort(index);
            }
            case 4: {
                return memory.getInt(index);
            }
            case 8: {
                return memory.getLong(index);
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setSendInfo(ByteBuffer memory, InetSocketAddress address) {
        int position = memory.position();
        int sockaddrPosition = position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO;
        try {
            memory.position(sockaddrPosition);
            int len = SockaddrIn.setAddress(memory, address);
            switch (Quiche.SIZEOF_SOCKLEN_T) {
                case 1: {
                    memory.put(position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO_LEN, (byte)len);
                    return;
                }
                case 2: {
                    memory.putShort(position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO_LEN, (short)len);
                    return;
                }
                case 4: {
                    memory.putInt(position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO_LEN, len);
                    return;
                }
                case 8: {
                    memory.putLong(position + Quiche.QUICHE_SEND_INFO_OFFSETOF_TO_LEN, len);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            memory.position(position);
        }
    }

    static boolean isSameAddress(ByteBuffer memory, ByteBuffer memory2) {
        long address2;
        long address1 = Quiche.memoryAddressWithPosition(memory) + (long)Quiche.QUICHE_SEND_INFO_OFFSETOF_TO;
        return SockaddrIn.cmp(address1, address2 = Quiche.memoryAddressWithPosition(memory2) + (long)Quiche.QUICHE_SEND_INFO_OFFSETOF_TO) == 0;
    }
}

