/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.projections;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.streams.Limit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EmailQueryView {
    public Flux<MessageId> listMailboxContent(MailboxId var1, Limit var2);

    public Flux<MessageId> listMailboxContentSortedByReceivedAt(MailboxId var1, Limit var2);

    public Flux<MessageId> listMailboxContentSinceReceivedAt(MailboxId var1, ZonedDateTime var2, Limit var3);

    public Flux<MessageId> listMailboxContentSinceReceivedAtSortedByReceivedAt(MailboxId var1, ZonedDateTime var2, Limit var3);

    public Flux<MessageId> listMailboxContentSinceSentAt(MailboxId var1, ZonedDateTime var2, Limit var3);

    public Mono<Void> delete(MailboxId var1, MessageId var2);

    public Mono<Void> delete(MailboxId var1);

    public Mono<Void> save(MailboxId var1, ZonedDateTime var2, ZonedDateTime var3, MessageId var4);

    public static class Entry {
        private final MailboxId mailboxId;
        private final MessageId messageId;
        private final ZonedDateTime sentAt;
        private final ZonedDateTime receivedAt;

        public Entry(MailboxId mailboxId, MessageId messageId, ZonedDateTime sentAt, ZonedDateTime receivedAt) {
            this.mailboxId = mailboxId;
            this.messageId = messageId;
            this.sentAt = sentAt;
            this.receivedAt = receivedAt;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public ZonedDateTime getSentAt() {
            return this.sentAt;
        }

        public ZonedDateTime getReceivedAt() {
            return this.receivedAt;
        }

        public final boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry entry = (Entry)o;
                return Objects.equals(this.mailboxId, entry.mailboxId) && Objects.equals(this.messageId, entry.messageId) && Objects.equals(this.sentAt, entry.sentAt) && Objects.equals(this.receivedAt, entry.receivedAt);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailboxId, this.messageId, this.sentAt, this.receivedAt);
        }
    }
}

