/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Number {
    public static final Logger LOGGER = LoggerFactory.getLogger(Number.class);
    public static final String VALIDATION_MESSAGE = "value should be positive and less than 2^53";
    private static final int ZERO_VALUE = 0;
    public static final long MAX_VALUE = LongMath.pow((long)2L, (int)53);
    public static final Number ZERO = new Number(0L);
    public static final Factory<Optional<Number>> DEFAULT_FACTORY = value -> Optional.of(value).filter(Number::isValid).map(Number::new);
    public static final Factory<Number> BOUND_SANITIZING_FACTORY = value -> {
        if (value < 0L) {
            LOGGER.warn("Received a negative Number");
            return new Number(0L);
        }
        if (value > MAX_VALUE) {
            LOGGER.warn("Received a too big Number");
            return new Number(MAX_VALUE);
        }
        return new Number(value);
    };
    private final long value;

    public static Number fromLong(long value) {
        return new Number(value);
    }

    private static boolean isValid(long value) {
        return value >= 0L && value <= MAX_VALUE;
    }

    private Number(long value) {
        Preconditions.checkArgument((boolean)Number.isValid(value), (Object)VALIDATION_MESSAGE);
        this.value = value;
    }

    @JsonValue
    public long asLong() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return Objects.equals(this.value, number.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    public static interface Factory<T> {
        public T from(long var1);
    }
}

