/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.commands;

import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.ExecutableCommand;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.CommandException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;

public abstract class AbstractCommand
implements ExecutableCommand {
    protected void validateState(SieveContext context) throws CommandException {
    }

    protected void updateState(SieveContext context) {
    }

    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        if (!arguments.getArgumentList().isEmpty()) {
            throw context.getCoordinate().syntaxException("Found unexpected arguments");
        }
    }

    protected void validateBlock(Block block, SieveContext context) throws SieveException {
        if (null != block) {
            throw context.getCoordinate().syntaxException("Found unexpected Block. Missing ';'?");
        }
    }

    @Override
    public Object execute(MailAdapter mail, Arguments arguments, Block block, SieveContext context) throws SieveException {
        this.validateState(context);
        this.validateArguments(arguments, context);
        this.validateBlock(block, context);
        Object result = this.executeBasic(mail, arguments, block, context);
        this.updateState(context);
        return result;
    }

    protected abstract Object executeBasic(MailAdapter var1, Arguments var2, Block var3, SieveContext var4) throws SieveException;
}

