/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.VacationReply;
import org.apache.james.transport.util.MimeMessageBodyGenerator;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationService;
import org.apache.mailet.Mail;
import org.apache.mailet.base.AutomaticallySentMailDetector;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class VacationMailet
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(VacationMailet.class);
    private final VacationService vacationService;
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final AutomaticallySentMailDetector automaticallySentMailDetector;
    private final MimeMessageBodyGenerator mimeMessageBodyGenerator;

    @Inject
    public VacationMailet(VacationService vacationService, ZonedDateTimeProvider zonedDateTimeProvider, AutomaticallySentMailDetector automaticallySentMailDetector, MimeMessageBodyGenerator mimeMessageBodyGenerator) {
        this.vacationService = vacationService;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.automaticallySentMailDetector = automaticallySentMailDetector;
        this.mimeMessageBodyGenerator = mimeMessageBodyGenerator;
    }

    public void service(Mail mail) {
        try {
            if (!mail.hasSender()) {
                return;
            }
            boolean hasReplyToHeaderField = Optional.ofNullable(mail.getMessage().getReplyTo()).map(replyToFields -> ((Address[])replyToFields).length > 0).orElse(false);
            if (!this.automaticallySentMailDetector.isAutomaticallySent(mail) && hasReplyToHeaderField) {
                ZonedDateTime processingDate = (ZonedDateTime)this.zonedDateTimeProvider.get();
                mail.getRecipients().forEach(mailAddress -> this.manageVacation((MailAddress)mailAddress, mail, processingDate));
            }
        }
        catch (AddressException e) {
            if (!e.getMessage().equals("Empty address")) {
                LOGGER.warn("Can not process vacation for one or more recipients in {}", (Object)mail.getRecipients(), (Object)e);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can not process vacation for one or more recipients in {}", (Object)mail.getRecipients(), (Object)e);
        }
    }

    private void manageVacation(MailAddress recipient, Mail processedMail, ZonedDateTime processingDate) {
        AccountId accountId = AccountId.fromString((String)recipient.toString());
        Mono vacation = this.vacationService.retrieveVacation(accountId);
        Mono alreadySent = this.vacationService.isNotificationRegistered(AccountId.fromString((String)recipient.toString()), RecipientId.fromMailAddress((MailAddress)processedMail.getMaybeSender().get()));
        Pair pair = (Pair)Flux.combineLatest((Publisher)vacation, (Publisher)alreadySent, Pair::of).blockFirst();
        this.sendNotificationIfRequired(recipient, processedMail, processingDate, (Vacation)pair.getKey(), (Boolean)pair.getValue());
    }

    private void sendNotificationIfRequired(MailAddress recipient, Mail processedMail, ZonedDateTime processingDate, Vacation vacation, Boolean alreadySent) {
        if (this.shouldSendNotification(processedMail, vacation, processingDate, alreadySent)) {
            this.sendNotification(recipient, processedMail, vacation);
        }
    }

    private boolean shouldSendNotification(Mail processedMail, Vacation vacation, ZonedDateTime processingDate, boolean alreadySent) {
        return vacation.isActiveAtDate(processingDate) && !alreadySent && this.isNoReplySender(processedMail) == false;
    }

    private Boolean isNoReplySender(Mail processedMail) {
        return processedMail.getMaybeSender().asOptional().map(address -> address.getLocalPart().toLowerCase(Locale.US).endsWith("-noreply")).orElse(true);
    }

    private void sendNotification(MailAddress recipient, Mail processedMail, Vacation vacation) {
        try {
            VacationReply vacationReply = VacationReply.builder(processedMail).receivedMailRecipient(recipient).vacation(vacation).build(this.mimeMessageBodyGenerator);
            this.sendNotification(vacationReply);
            this.vacationService.registerNotification(AccountId.fromString((String)recipient.toString()), RecipientId.fromMailAddress((MailAddress)processedMail.getMaybeSender().get()), vacation.getToDate()).block();
        }
        catch (MessagingException e) {
            LOGGER.warn("Failed to send JMAP vacation notification from {} to {}", new Object[]{recipient, processedMail.getMaybeSender(), e});
        }
    }

    private void sendNotification(VacationReply vacationReply) throws MessagingException {
        this.getMailetContext().sendMail(vacationReply.getSender(), vacationReply.getRecipients(), vacationReply.getMimeMessage());
    }
}

