/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.ipfilter;

import com.datastax.shaded.netty.channel.ChannelHandler;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import com.datastax.shaded.netty.handler.ipfilter.IpFilterRule;
import com.datastax.shaded.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        if (rules == null) {
            throw new NullPointerException("rules");
        }
        this.rules = rules;
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

