/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.james.quota.search.QuotaClause;
import org.apache.james.quota.search.QuotaQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

class QuotaQueryConverter {
    private final Map<Class<? extends QuotaClause>, Function<QuotaClause, QueryBuilder>> clauseConverter;

    QuotaQueryConverter() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(QuotaClause.HasDomain.class, this::convertHasDomain);
        builder.put(QuotaClause.And.class, this::disableNestedAnd);
        builder.put(QuotaClause.MoreThan.class, this::convertMoreThan);
        builder.put(QuotaClause.LessThan.class, this::convertLessThan);
        this.clauseConverter = builder.build();
    }

    QueryBuilder from(QuotaQuery query) {
        List clauses = query.getClause().getClauses();
        if (clauses.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        if (clauses.size() == 1) {
            return this.singleClauseAsESQuery((QuotaClause)clauses.get(0));
        }
        return this.clausesAsAndESQuery(clauses);
    }

    private BoolQueryBuilder clausesAsAndESQuery(List<QuotaClause> clauses) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        clauses.stream().map(this::singleClauseAsESQuery).forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        return boolQueryBuilder;
    }

    private QueryBuilder disableNestedAnd(QuotaClause clause) {
        throw new IllegalArgumentException("Nested \"And\" clauses are not supported");
    }

    private TermQueryBuilder convertHasDomain(QuotaClause clause) {
        QuotaClause.HasDomain hasDomain = (QuotaClause.HasDomain)clause;
        return QueryBuilders.termQuery((String)"domain", (String)hasDomain.getDomain().asString());
    }

    private RangeQueryBuilder convertMoreThan(QuotaClause clause) {
        QuotaClause.MoreThan moreThan = (QuotaClause.MoreThan)clause;
        return QueryBuilders.rangeQuery((String)"quotaRatio").gte((Object)moreThan.getQuotaBoundary().getRatio());
    }

    private RangeQueryBuilder convertLessThan(QuotaClause clause) {
        QuotaClause.LessThan lessThan = (QuotaClause.LessThan)clause;
        return QueryBuilders.rangeQuery((String)"quotaRatio").lte((Object)lessThan.getQuotaBoundary().getRatio());
    }

    private QueryBuilder singleClauseAsESQuery(QuotaClause clause) {
        return this.clauseConverter.get(clause.getClass()).apply(clause);
    }
}

