/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.elasticsearch.client.ml.inference.SimpleBoundedInputStream;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class InferenceToXContentCompressor {
    private static final int BUFFER_SIZE = 4096;
    private static final long MAX_INFLATED_BYTES = 1000000000L;

    private InferenceToXContentCompressor() {
    }

    public static <T extends ToXContentObject> String deflate(T objectToCompress) throws IOException {
        BytesReference reference = XContentHelper.toXContent(objectToCompress, (XContentType)XContentType.JSON, (boolean)false);
        return InferenceToXContentCompressor.deflate(reference);
    }

    public static <T> T inflate(String compressedString, CheckedFunction<XContentParser, T, IOException> parserFunction, NamedXContentRegistry xContentRegistry) throws IOException {
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)InferenceToXContentCompressor.inflate(compressedString, 1000000000L), (XContentType)XContentType.JSON);){
            Object object = parserFunction.apply((Object)parser);
            return (T)object;
        }
    }

    static BytesReference inflate(String compressedString, long streamSize) throws IOException {
        byte[] compressedBytes = Base64.getDecoder().decode(compressedString.getBytes(StandardCharsets.UTF_8));
        GZIPInputStream gzipStream = new GZIPInputStream((InputStream)new BytesArray(compressedBytes).streamInput(), 4096);
        SimpleBoundedInputStream inflateStream = new SimpleBoundedInputStream(gzipStream, streamSize);
        return Streams.readFully((InputStream)inflateStream);
    }

    private static String deflate(BytesReference reference) throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        try (GZIPOutputStream compressedOutput = new GZIPOutputStream((OutputStream)out, 4096);){
            reference.writeTo((OutputStream)compressedOutput);
        }
        return new String(Base64.getEncoder().encode(BytesReference.toBytes((BytesReference)out.bytes())), StandardCharsets.UTF_8);
    }
}

