/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsStats;
import org.elasticsearch.client.transform.AcknowledgedTasksResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetDataFrameAnalyticsStatsResponse {
    private static final ParseField DATA_FRAME_ANALYTICS = new ParseField("data_frame_analytics", new String[0]);
    private static final ConstructingObjectParser<GetDataFrameAnalyticsStatsResponse, Void> PARSER = new ConstructingObjectParser("get_data_frame_analytics_stats_response", true, args -> new GetDataFrameAnalyticsStatsResponse((List)args[0], (List)args[1], (List)args[2]));
    private final List<DataFrameAnalyticsStats> analyticsStats;
    private final List<TaskOperationFailure> taskFailures;
    private final List<ElasticsearchException> nodeFailures;

    public static GetDataFrameAnalyticsStatsResponse fromXContent(XContentParser parser) {
        return (GetDataFrameAnalyticsStatsResponse)PARSER.apply(parser, null);
    }

    public GetDataFrameAnalyticsStatsResponse(List<DataFrameAnalyticsStats> analyticsStats, @Nullable List<TaskOperationFailure> taskFailures, @Nullable List<? extends ElasticsearchException> nodeFailures) {
        this.analyticsStats = analyticsStats;
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(taskFailures);
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(nodeFailures);
    }

    public List<DataFrameAnalyticsStats> getAnalyticsStats() {
        return this.analyticsStats;
    }

    public List<ElasticsearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataFrameAnalyticsStatsResponse other = (GetDataFrameAnalyticsStatsResponse)o;
        return Objects.equals(this.analyticsStats, other.analyticsStats) && Objects.equals(this.nodeFailures, other.nodeFailures) && Objects.equals(this.taskFailures, other.taskFailures);
    }

    public int hashCode() {
        return Objects.hash(this.analyticsStats, this.nodeFailures, this.taskFailures);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> DataFrameAnalyticsStats.fromXContent(p), DATA_FRAME_ANALYTICS);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent((XContentParser)p), AcknowledgedTasksResponse.TASK_FAILURES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), AcknowledgedTasksResponse.NODE_FAILURES);
    }
}

