/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.IdleRequest;
import org.apache.james.imap.message.response.ContinuationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleProcessor
extends AbstractMailboxProcessor<IdleRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleProcessor.class);
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_IDLE);
    public static final int DEFAULT_SCHEDULED_POOL_CORE_SIZE = 5;
    private static final String DONE = "DONE";
    private TimeUnit heartbeatIntervalUnit;
    private long heartbeatInterval;
    private boolean enableIdle;
    private ScheduledExecutorService heartbeatExecutor;

    public IdleProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IdleRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.heartbeatInterval = imapConfiguration.getIdleTimeInterval();
        this.heartbeatIntervalUnit = imapConfiguration.getIdleTimeIntervalUnit();
        this.enableIdle = imapConfiguration.isEnableIdle();
        if (this.enableIdle) {
            NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
            this.heartbeatExecutor = Executors.newScheduledThreadPool(5, (ThreadFactory)threadFactory);
        }
    }

    @Override
    protected void processRequest(IdleRequest request, final ImapSession session, final ImapProcessor.Responder responder) {
        SelectedMailbox sm = session.getSelected();
        if (sm != null) {
            sm.registerIdle(new IdleMailboxListener(session, responder));
        }
        final AtomicBoolean idleActive = new AtomicBoolean(true);
        session.pushLineHandler((session1, data) -> {
            String line = data.length > 2 ? new String(data, 0, data.length - 2) : "";
            if (sm != null) {
                sm.unregisterIdle();
            }
            session1.popLineHandler();
            if (!DONE.equals(line.toUpperCase(Locale.US))) {
                String message = String.format("Continuation for IMAP IDLE was not understood. Expected 'DONE', got '%s'.", line);
                StatusResponse response = this.getStatusResponseFactory().taggedBad(request.getTag(), request.getCommand(), new HumanReadableText("org.apache.james.imap.INVALID_CONTINUATION", "failed. " + message));
                LOGGER.info(message);
                responder.respond(response);
            } else {
                this.okComplete(request, responder);
            }
            idleActive.set(false);
        });
        if (this.enableIdle) {
            this.heartbeatExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                        StatusResponse response = IdleProcessor.this.getStatusResponseFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                        responder.respond(response);
                        IdleProcessor.this.heartbeatExecutor.schedule(this, IdleProcessor.this.heartbeatInterval, IdleProcessor.this.heartbeatIntervalUnit);
                    }
                }
            }, this.heartbeatInterval, this.heartbeatIntervalUnit);
        }
        responder.respond(new ContinuationResponse(HumanReadableText.IDLING));
        this.unsolicitedResponses(session, responder, false);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(IdleRequest message) {
        return MDCBuilder.create().addToContext("action", "IDLE").build();
    }

    private class IdleMailboxListener
    implements EventListener {
        private final ImapProcessor.Responder responder;
        private final ImapSession session;

        public IdleMailboxListener(ImapSession session, ImapProcessor.Responder responder) {
            this.session = session;
            this.responder = responder;
        }

        public boolean isHandling(Event event) {
            return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.FlagsUpdated;
        }

        public void event(Event event) {
            IdleProcessor.this.unsolicitedResponses(this.session, this.responder, false);
        }

        public EventListener.ExecutionMode getExecutionMode() {
            return EventListener.ExecutionMode.ASYNCHRONOUS;
        }
    }
}

