/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.InvalidUsernameException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.AddUserRequest;
import org.apache.james.webadmin.dto.VerifyUserRequest;
import org.apache.james.webadmin.service.UserService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractException;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class UserRoutes
implements Routes {
    private static final String USER_NAME = ":userName";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserRoutes.class);
    public static final String USERS = "/users";
    private static final String FORCE_PARAM = "force";
    private static final String VERIFY = "verify";
    private final UserService userService;
    private final JsonTransformer jsonTransformer;
    private final JsonExtractor<VerifyUserRequest> jsonExtractorVerify;
    private final CanSendFrom canSendFrom;
    private final JsonExtractor<AddUserRequest> jsonExtractor;
    private Service service;

    @Inject
    public UserRoutes(UserService userService, CanSendFrom canSendFrom, JsonTransformer jsonTransformer) {
        this.userService = userService;
        this.jsonTransformer = jsonTransformer;
        this.canSendFrom = canSendFrom;
        this.jsonExtractor = new JsonExtractor(AddUserRequest.class, new Module[0]);
        this.jsonExtractorVerify = new JsonExtractor(VerifyUserRequest.class, new Module[0]);
    }

    public String getBasePath() {
        return USERS;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetUsers();
        this.defineCreateUser();
        this.defineDeleteUser();
        this.defineAllowedFromHeaders();
        this.defineUserExist();
        this.defineVerifyUsers();
    }

    public void defineVerifyUsers() {
        this.service.post("/users/:userName/verify", this::verifyUser);
    }

    public void defineDeleteUser() {
        this.service.delete("/users/:userName", this::removeUser);
    }

    public void defineUserExist() {
        this.service.head("/users/:userName", this::userExist);
    }

    public void defineCreateUser() {
        this.service.put("/users/:userName", this::upsertUser);
    }

    public void defineGetUsers() {
        this.service.get(USERS, (request, response) -> this.userService.getUsers(), (ResponseTransformer)this.jsonTransformer);
    }

    public void defineAllowedFromHeaders() {
        this.service.get("/users/:userName/allowedFromHeaders", this::allowedFromHeaders, (ResponseTransformer)this.jsonTransformer);
    }

    private String removeUser(Request request, Response response) {
        Username username = this.extractUsername(request);
        try {
            this.userService.removeUser(username);
            return Responses.returnNoContent((Response)response);
        }
        catch (UsersRepositoryException e) {
            throw ErrorResponder.builder().statusCode(204).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The user " + username + " does not exists").cause((Exception)((Object)e)).haltError();
        }
    }

    private String userExist(Request request, Response response) throws UsersRepositoryException {
        Username username = this.extractUsername(request);
        if (this.userService.userExists(username)) {
            response.status(200);
        } else {
            response.status(404);
        }
        return "";
    }

    private HaltException upsertUser(Request request, Response response) throws Exception {
        Username username = this.extractUsername(request);
        try {
            boolean isForced = request.queryParams().contains(FORCE_PARAM);
            if (isForced) {
                this.userService.upsertUser(username, ((AddUserRequest)this.jsonExtractor.parse(request.body())).getPassword());
            } else {
                this.userService.insertUser(username, ((AddUserRequest)this.jsonExtractor.parse(request.body())).getPassword());
            }
            return Spark.halt((int)204);
        }
        catch (InvalidUsernameException e) {
            LOGGER.info("Invalid username", (Throwable)e);
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Username supplied is invalid").cause((Exception)((Object)e)).haltError();
        }
        catch (AlreadyExistInUsersRepositoryException e) {
            LOGGER.info(e.getMessage());
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).cause((Exception)((Object)e)).haltError();
        }
        catch (UsersRepositoryException e) {
            String errorMessage = String.format("Error while upserting user '%s'", username);
            LOGGER.info(errorMessage, (Throwable)e);
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(errorMessage).cause((Exception)((Object)e)).haltError();
        }
    }

    private String verifyUser(Request request, Response response) throws UsersRepositoryException {
        Username username = this.extractUsername(request);
        try {
            if (this.userService.verifyUser(username, ((VerifyUserRequest)this.jsonExtractorVerify.parse(request.body())).getPassword())) {
                response.status(204);
            } else {
                response.status(401);
            }
            return "";
        }
        catch (JsonExtractException e) {
            LOGGER.info("Error while deserializing verifyUser request", (Throwable)e);
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Error while deserializing verifyUser request").cause((Exception)((Object)e)).haltError();
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Invalid user path", (Throwable)e);
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid user path").cause((Exception)e).haltError();
        }
    }

    private List<String> allowedFromHeaders(Request request, Response response) {
        Username username = this.extractUsername(request);
        try {
            if (!this.userService.userExists(username)) {
                LOGGER.info("Allowed FROM headers requested for an unknown user: '{}", (Object)username.asString());
                throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(String.format("user '%s' does not exist", username.asString())).haltError();
            }
            return (List)this.canSendFrom.allValidFromAddressesForUser(username).map(MailAddress::asString).collect(ImmutableList.toImmutableList());
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException | UsersRepositoryException e) {
            String errorMessage = String.format("Error while listing allowed From headers for user '%s'", username);
            LOGGER.info(errorMessage, e);
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(errorMessage).cause((Exception)e).haltError();
        }
    }

    private Username extractUsername(Request request) {
        return Username.of((String)request.params(USER_NAME));
    }
}

