/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.jndi;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JNDIExtendedResponse
implements ExtendedResponse {
    private static final long serialVersionUID = -9210853181740736844L;
    @NotNull
    private final ExtendedResult r;

    public JNDIExtendedResponse(@NotNull ExtendedResult r) {
        this.r = r;
    }

    public JNDIExtendedResponse(@NotNull ExtendedResponse r) throws NamingException {
        this(JNDIExtendedResponse.toSDKExtendedResult(r));
    }

    JNDIExtendedResponse(@Nullable String id, @Nullable byte[] berValue, int offset, int length) throws NamingException {
        ASN1OctetString value;
        if (berValue == null) {
            value = null;
        } else {
            try {
                if (offset == 0 && length == berValue.length) {
                    value = ASN1OctetString.decodeAsOctetString(berValue);
                } else {
                    byte[] valueBytes = new byte[length];
                    System.arraycopy(berValue, offset, valueBytes, 0, length);
                    value = ASN1OctetString.decodeAsOctetString(valueBytes);
                }
            }
            catch (ASN1Exception ae) {
                throw new NamingException(StaticUtils.getExceptionMessage(ae));
            }
        }
        this.r = new ExtendedResult(-1, ResultCode.SUCCESS, null, null, null, id, value, null);
    }

    @Override
    @Nullable
    public String getID() {
        return this.r.getOID();
    }

    @Override
    @Nullable
    public byte[] getEncodedValue() {
        ASN1OctetString value = this.r.getValue();
        if (value == null) {
            return null;
        }
        return value.encode();
    }

    @NotNull
    public ExtendedResult toSDKExtendedResult() {
        return this.r;
    }

    @Nullable
    public static ExtendedResult toSDKExtendedResult(@Nullable ExtendedResponse r) throws NamingException {
        if (r == null) {
            return null;
        }
        byte[] encodedValue = r.getEncodedValue();
        JNDIExtendedResponse response = encodedValue == null ? new JNDIExtendedResponse(r.getID(), null, 0, 0) : new JNDIExtendedResponse(r.getID(), encodedValue, 0, encodedValue.length);
        return response.toSDKExtendedResult();
    }

    @NotNull
    public String toString() {
        return this.r.toString();
    }
}

