/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;

public class MailboxNamespace {
    private final Type type;
    private final Optional<Username> owner;

    public static MailboxNamespace delegated(Username owner) {
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        return new MailboxNamespace(Type.Delegated, Optional.of(owner));
    }

    public static MailboxNamespace personal() {
        return new MailboxNamespace(Type.Personal, Optional.empty());
    }

    private MailboxNamespace(Type type, Optional<Username> owner) {
        this.type = type;
        this.owner = owner;
    }

    public Type getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<Username> getOwner() {
        return this.owner;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxNamespace) {
            MailboxNamespace that = (MailboxNamespace)o;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.owner, that.owner);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.owner});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("owner", this.owner).toString();
    }

    public static enum Type {
        Delegated("Delegated"),
        Personal("Personal");

        private final String type;

        private Type(String type) {
            this.type = type;
        }
    }
}

