/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.core.MailAddress;

public class PerRecipientHeaders
implements Serializable {
    private Multimap<MailAddress, Header> headersByRecipient = ArrayListMultimap.create();

    public Multimap<MailAddress, Header> getHeadersByRecipient() {
        return ArrayListMultimap.create(this.headersByRecipient);
    }

    public Collection<MailAddress> getRecipientsWithSpecificHeaders() {
        return this.headersByRecipient.keySet();
    }

    public Collection<Header> getHeadersForRecipient(MailAddress recipient) {
        return this.headersByRecipient.get(recipient);
    }

    public Collection<String> getHeaderNamesForRecipient(MailAddress recipient) {
        return this.headersByRecipient.get(recipient).stream().map(Header::getName).collect(Guavate.toImmutableSet());
    }

    public PerRecipientHeaders addHeaderForRecipient(Header header, MailAddress recipient) {
        this.headersByRecipient.put(recipient, header);
        return this;
    }

    public PerRecipientHeaders addHeaderForRecipient(Header.Builder header, MailAddress recipient) {
        this.headersByRecipient.put(recipient, header.build());
        return this;
    }

    public void addAll(PerRecipientHeaders other) {
        this.headersByRecipient.putAll(other.headersByRecipient);
    }

    public final boolean equals(Object o) {
        if (o instanceof PerRecipientHeaders) {
            PerRecipientHeaders that = (PerRecipientHeaders)o;
            return Objects.equal(this.headersByRecipient, that.headersByRecipient);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.headersByRecipient);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("headersByRecipient", this.headersByRecipient).toString();
    }

    public static class Header
    implements Serializable {
        private final String name;
        private final String value;

        public static Builder builder() {
            return new Builder();
        }

        @VisibleForTesting
        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Header) {
                Header that = (Header)o;
                return Objects.equal(this.name, that.name) && Objects.equal(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode(this.name, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("value", this.value).toString();
        }

        public static class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Header build() {
                Preconditions.checkNotNull(this.name);
                Preconditions.checkNotNull(this.value);
                return new Header(this.name, this.value);
            }
        }
    }
}

