/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.function.Consumer;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.StructuredLogger;
import org.slf4j.Logger;

public class MDCStructuredLogger
implements StructuredLogger {
    private final Logger logger;
    private final MDCBuilder mdcBuilder;

    public static MDCStructuredLogger forLogger(Logger logger) {
        return new MDCStructuredLogger(logger);
    }

    public MDCStructuredLogger(Logger logger) {
        this.logger = logger;
        this.mdcBuilder = MDCBuilder.create();
    }

    @Override
    public StructuredLogger addField(String name, Object value) {
        this.mdcBuilder.addContext(name, value);
        return this;
    }

    @Override
    public void log(Consumer<Logger> logOperation) {
        MDCBuilder.withMdc(this.mdcBuilder, () -> logOperation.accept(this.logger));
    }
}

