/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.james.jdkim.canon.AbstractOutputStreamTestCase;
import org.apache.james.jdkim.canon.DigestOutputStream;

public class DigestOutputStreamTest
extends AbstractOutputStreamTestCase {
    private byte[] testData;
    private byte[] expectedDigest;

    protected void setUp() throws Exception {
        this.testData = new byte[4096];
        for (int i = 0; i < this.testData.length; ++i) {
            this.testData[i] = (byte)((i * i * 4095 + (this.testData.length - i) * 17) % 128);
        }
        MessageDigest md = MessageDigest.getInstance("sha-256");
        md.update(this.testData);
        this.expectedDigest = md.digest();
    }

    public void testSingleBytes() throws NoSuchAlgorithmException, IOException {
        DigestOutputStream dos = new DigestOutputStream(MessageDigest.getInstance("sha-256"));
        for (byte aTestData : this.testData) {
            dos.write((int)aTestData);
        }
        dos.close();
        byte[] digest = dos.getDigest();
        DigestOutputStreamTest.assertTrue((boolean)Arrays.equals(this.expectedDigest, digest));
    }

    public void testChunks() throws NoSuchAlgorithmException, IOException {
        DigestOutputStream dos = new DigestOutputStream(MessageDigest.getInstance("sha-256"));
        this.chunker(this.testData, (OutputStream)dos);
        byte[] digest = dos.getDigest();
        DigestOutputStreamTest.assertTrue((boolean)Arrays.equals(this.expectedDigest, digest));
    }

    public void testChunksAndPassthrough() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DigestOutputStream dos = new DigestOutputStream(MessageDigest.getInstance("sha-256"), (OutputStream)bos);
        this.chunker(this.testData, (OutputStream)dos);
        byte[] digest = dos.getDigest();
        DigestOutputStreamTest.assertTrue((boolean)Arrays.equals(this.expectedDigest, digest));
        DigestOutputStreamTest.assertTrue((boolean)Arrays.equals(this.testData, bos.toByteArray()));
    }
}

