/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;

public final class MoreLikeThis {
    public static final int DEFAULT_MAX_NUM_TOKENS_PARSED = 5000;
    public static final Analyzer DEFAULT_ANALYZER = new StandardAnalyzer(Version.LUCENE_36);
    public static final int DEFAULT_MIN_TERM_FREQ = 2;
    public static final int DEFAULT_MIN_DOC_FREQ = 5;
    public static final boolean DEFAULT_BOOST = false;
    public static final String[] DEFAULT_FIELD_NAMES = new String[]{"contents"};
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    public static final Set<String> DEFAULT_STOP_WORDS = null;
    private Set<String> stopWords = DEFAULT_STOP_WORDS;
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    private Analyzer analyzer = DEFAULT_ANALYZER;
    private int minTermFreq = 2;
    private int minDocFreq = 5;
    private boolean boost = false;
    private String[] fieldNames = DEFAULT_FIELD_NAMES;
    private int maxNumTokensParsed = 5000;
    private int minWordLen = 0;
    private int maxWordLen = 0;
    private int maxQueryTerms = 25;
    private Similarity similarity;
    private final IndexReader ir;

    public MoreLikeThis(IndexReader ir) {
        this(ir, new DefaultSimilarity());
    }

    public MoreLikeThis(IndexReader ir, Similarity sim) {
        this.ir = ir;
        this.similarity = sim;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public int getMinTermFreq() {
        return this.minTermFreq;
    }

    public void setMinTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public boolean isBoost() {
        return this.boost;
    }

    public void setBoost(boolean boost) {
        this.boost = boost;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public int getMinWordLen() {
        return this.minWordLen;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public int getMaxWordLen() {
        return this.maxWordLen;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public void setStopWords(Set<String> stopWords) {
        this.stopWords = stopWords;
    }

    public Set<String> getStopWords() {
        return this.stopWords;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public int getMaxNumTokensParsed() {
        return this.maxNumTokensParsed;
    }

    public void setMaxNumTokensParsed(int i) {
        this.maxNumTokensParsed = i;
    }

    public Query like(int docNum) throws IOException {
        if (this.fieldNames == null) {
            Collection<String> fields = ReaderUtil.getIndexedFields(this.ir);
            this.fieldNames = fields.toArray(new String[fields.size()]);
        }
        return this.createQuery(this.retrieveTerms(docNum));
    }

    public Query like(File f) throws IOException {
        if (this.fieldNames == null) {
            Collection<String> fields = ReaderUtil.getIndexedFields(this.ir);
            this.fieldNames = fields.toArray(new String[fields.size()]);
        }
        return this.like(new FileReader(f));
    }

    public Query like(URL u) throws IOException {
        return this.like(new InputStreamReader(u.openConnection().getInputStream()));
    }

    public Query like(InputStream is) throws IOException {
        return this.like(new InputStreamReader(is));
    }

    public Query like(Reader r) throws IOException {
        return this.createQuery(this.retrieveTerms(r));
    }

    private Query createQuery(PriorityQueue q) {
        Object cur;
        BooleanQuery query = new BooleanQuery();
        int qterms = 0;
        float bestScore = 0.0f;
        while ((cur = q.pop()) != null) {
            Object[] ar = (Object[])cur;
            JackrabbitTermQuery tq = new JackrabbitTermQuery(new Term((String)ar[1], (String)ar[0]));
            if (this.boost) {
                if (qterms == 0) {
                    bestScore = ((Float)ar[2]).floatValue();
                }
                float myScore = ((Float)ar[2]).floatValue();
                tq.setBoost(myScore / bestScore);
            }
            try {
                query.add(tq, BooleanClause.Occur.SHOULD);
            }
            catch (BooleanQuery.TooManyClauses ignore) {
                break;
            }
            if (this.maxQueryTerms <= 0 || ++qterms < this.maxQueryTerms) continue;
            break;
        }
        return query;
    }

    private PriorityQueue createQueue(Map<String, Int> words) throws IOException {
        int numDocs = this.ir.numDocs();
        FreqQ res = new FreqQ(words.size());
        for (Map.Entry<String, Int> entry : words.entrySet()) {
            String word = entry.getKey();
            int tf = entry.getValue().x;
            if (this.minTermFreq > 0 && tf < this.minTermFreq) continue;
            String topField = this.fieldNames[0];
            int docFreq = 0;
            for (int i = 0; i < this.fieldNames.length; ++i) {
                int freq = this.ir.docFreq(new Term(this.fieldNames[i], word));
                topField = freq > docFreq ? this.fieldNames[i] : topField;
                docFreq = freq > docFreq ? freq : docFreq;
            }
            if (this.minDocFreq > 0 && docFreq < this.minDocFreq || docFreq == 0) continue;
            float idf = this.similarity.idf(docFreq, numDocs);
            float score = (float)tf * idf;
            res.insertWithOverflow(new Object[]{word, topField, new Float(score), new Float(idf), new Integer(docFreq), new Integer(tf)});
        }
        return res;
    }

    public String describeParams() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tmaxQueryTerms  : ").append(this.maxQueryTerms).append("\n");
        sb.append("\tminWordLen     : ").append(this.minWordLen).append("\n");
        sb.append("\tmaxWordLen     : ").append(this.maxWordLen).append("\n");
        sb.append("\tfieldNames     : ");
        String delim = "";
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            sb.append(delim).append(fieldName);
            delim = ", ";
        }
        sb.append("\n");
        sb.append("\tboost          : ").append(this.boost).append("\n");
        sb.append("\tminTermFreq    : ").append(this.minTermFreq).append("\n");
        sb.append("\tminDocFreq     : ").append(this.minDocFreq).append("\n");
        return sb.toString();
    }

    public PriorityQueue retrieveTerms(int docNum) throws IOException {
        HashMap<String, Int> termFreqMap = new HashMap<String, Int>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            TermFreqVector vector = this.ir.getTermFreqVector(docNum, fieldName);
            if (vector == null) {
                Document d = this.ir.document(docNum);
                String[] text = d.getValues(fieldName);
                if (text == null) continue;
                for (int j = 0; j < text.length; ++j) {
                    this.addTermFrequencies(new StringReader(text[j]), termFreqMap, fieldName);
                }
                continue;
            }
            this.addTermFrequencies(termFreqMap, vector);
        }
        return this.createQueue(termFreqMap);
    }

    private void addTermFrequencies(Map<String, Int> termFreqMap, TermFreqVector vector) {
        String[] terms = vector.getTerms();
        int[] freqs = vector.getTermFrequencies();
        for (int j = 0; j < terms.length; ++j) {
            String term = terms[j];
            if (this.isNoiseWord(term)) continue;
            Int cnt = termFreqMap.get(term);
            if (cnt == null) {
                cnt = new Int();
                termFreqMap.put(term, cnt);
                cnt.x = freqs[j];
                continue;
            }
            cnt.x += freqs[j];
        }
    }

    private void addTermFrequencies(Reader r, Map<String, Int> termFreqMap, String fieldName) throws IOException {
        TokenStream ts = this.analyzer.tokenStream(fieldName, r);
        int tokenCount = 0;
        while (ts.incrementToken()) {
            TermAttribute term = ts.getAttribute(TermAttribute.class);
            String word = term.term();
            if (++tokenCount > this.maxNumTokensParsed) break;
            if (this.isNoiseWord(word)) continue;
            Int cnt = termFreqMap.get(word);
            if (cnt == null) {
                termFreqMap.put(word, new Int());
                continue;
            }
            ++cnt.x;
        }
        ts.end();
        ts.close();
    }

    private boolean isNoiseWord(String term) {
        int len = term.length();
        if (this.minWordLen > 0 && len < this.minWordLen) {
            return true;
        }
        if (this.maxWordLen > 0 && len > this.maxWordLen) {
            return true;
        }
        return this.stopWords != null && this.stopWords.contains(term);
    }

    public PriorityQueue retrieveTerms(Reader r) throws IOException {
        HashMap<String, Int> words = new HashMap<String, Int>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            this.addTermFrequencies(r, words, fieldName);
        }
        return this.createQueue(words);
    }

    public String[] retrieveInterestingTerms(int docNum) throws IOException {
        Object cur;
        ArrayList<String> al = new ArrayList<String>(this.maxQueryTerms);
        PriorityQueue pq = this.retrieveTerms(docNum);
        int lim = this.maxQueryTerms;
        while ((cur = pq.pop()) != null && lim-- > 0) {
            Object[] ar = (Object[])cur;
            al.add((String)ar[0]);
        }
        return al.toArray(new String[al.size()]);
    }

    public String[] retrieveInterestingTerms(Reader r) throws IOException {
        Object cur;
        ArrayList<String> al = new ArrayList<String>(this.maxQueryTerms);
        PriorityQueue pq = this.retrieveTerms(r);
        int lim = this.maxQueryTerms;
        while ((cur = pq.pop()) != null && lim-- > 0) {
            Object[] ar = (Object[])cur;
            al.add((String)ar[0]);
        }
        return al.toArray(new String[al.size()]);
    }

    private static class FreqQ
    extends PriorityQueue {
        FreqQ(int s) {
            this.initialize(s);
        }

        protected boolean lessThan(Object a, Object b) {
            Object[] aa = (Object[])a;
            Object[] bb = (Object[])b;
            Float fa = (Float)aa[2];
            Float fb = (Float)bb[2];
            return fa.floatValue() > fb.floatValue();
        }
    }

    private static class Int {
        int x = 1;

        Int() {
        }
    }
}

