/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBootstrapBag;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ProcessingProviders;

class ProcessingProvidersConfigurator
implements BootstrapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(ProcessingProvidersConfigurator.class.getName());

    ProcessingProvidersConfigurator() {
    }

    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
    }

    public void postInit(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ComponentBag componentBag = serverBag.getRuntimeConfig().getComponentBag();
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(ResourceConfig.unwrapApplication(serverBag.getRuntimeConfig()).getClass(), NameBinding.class);
        MultivaluedHashMap nameBoundRespFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundReqFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundReaderInterceptorsInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundWriterInterceptorsInverse = new MultivaluedHashMap();
        Iterable responseFilters = Providers.getAllRankedProviders((InjectionManager)injectionManager, ContainerResponseFilter.class);
        MultivaluedMap nameBoundResponseFilters = ProcessingProvidersConfigurator.filterNameBound(responseFilters, null, componentBag, applicationNameBindings, nameBoundRespFiltersInverse);
        Iterable requestFilters = Providers.getAllRankedProviders((InjectionManager)injectionManager, ContainerRequestFilter.class);
        ArrayList<RankedProvider<ContainerRequestFilter>> preMatchFilters = new ArrayList<RankedProvider<ContainerRequestFilter>>();
        MultivaluedMap nameBoundReqFilters = ProcessingProvidersConfigurator.filterNameBound(requestFilters, preMatchFilters, componentBag, applicationNameBindings, nameBoundReqFiltersInverse);
        Iterable readerInterceptors = Providers.getAllRankedProviders((InjectionManager)injectionManager, ReaderInterceptor.class);
        MultivaluedMap nameBoundReaderInterceptors = ProcessingProvidersConfigurator.filterNameBound(readerInterceptors, null, componentBag, applicationNameBindings, nameBoundReaderInterceptorsInverse);
        Iterable writerInterceptors = Providers.getAllRankedProviders((InjectionManager)injectionManager, WriterInterceptor.class);
        MultivaluedMap nameBoundWriterInterceptors = ProcessingProvidersConfigurator.filterNameBound(writerInterceptors, null, componentBag, applicationNameBindings, nameBoundWriterInterceptorsInverse);
        Iterable dynamicFeatures = Providers.getAllProviders((InjectionManager)injectionManager, DynamicFeature.class);
        ProcessingProviders processingProviders = new ProcessingProviders(nameBoundReqFilters, (MultivaluedMap<RankedProvider<ContainerRequestFilter>, Class<? extends Annotation>>)nameBoundReqFiltersInverse, nameBoundResponseFilters, (MultivaluedMap<RankedProvider<ContainerResponseFilter>, Class<? extends Annotation>>)nameBoundRespFiltersInverse, nameBoundReaderInterceptors, (MultivaluedMap<RankedProvider<ReaderInterceptor>, Class<? extends Annotation>>)nameBoundReaderInterceptorsInverse, nameBoundWriterInterceptors, (MultivaluedMap<RankedProvider<WriterInterceptor>, Class<? extends Annotation>>)nameBoundWriterInterceptorsInverse, requestFilters, preMatchFilters, responseFilters, readerInterceptors, writerInterceptors, dynamicFeatures);
        serverBag.setProcessingProviders(processingProviders);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatchingFilters, ComponentBag componentBag, Collection<Class<? extends Annotation>> applicationNameBindings, MultivaluedMap<RankedProvider<T>, Class<? extends Annotation>> inverseNameBoundMap) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            boolean preMatching;
            ContractProvider model;
            RankedProvider<T> provider = it.next();
            Class providerClass = provider.getProvider().getClass();
            Set contractTypes = provider.getContractTypes();
            if (contractTypes != null && !contractTypes.contains(providerClass)) {
                providerClass = ReflectionHelper.theMostSpecificTypeOf((Set)contractTypes);
            }
            if ((model = componentBag.getModel(providerClass)) == null) {
                model = ComponentBag.modelFor((Class)providerClass);
            }
            boolean bl = preMatching = providerClass.getAnnotation(PreMatching.class) != null;
            if (preMatching && preMatchingFilters != null) {
                it.remove();
                preMatchingFilters.add((RankedProvider<ContainerRequestFilter>)new RankedProvider((Object)((ContainerRequestFilter)provider.getProvider()), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty() && applicationNameBindings.containsAll(model.getNameBindings())) {
                nameBound = false;
            }
            if (!nameBound) continue;
            if (!preMatching) {
                it.remove();
                for (Class binding : model.getNameBindings()) {
                    result.add((Object)binding, provider);
                    inverseNameBoundMap.add(provider, (Object)binding);
                }
                continue;
            }
            LOGGER.warning(LocalizationMessages.PREMATCHING_ALSO_NAME_BOUND(providerClass));
        }
        return result;
    }
}

