/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.queue.serializer;

import java.util.HashMap;
import java.util.Map;

public enum QueueSerializerType {
    PLAIN(1);

    private static final Map<Byte, QueueSerializerType> TYPE_MAP;
    private final byte type;

    private QueueSerializerType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static QueueSerializerType deserialize(byte type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = new HashMap<Byte, QueueSerializerType>();
        for (QueueSerializerType type : QueueSerializerType.values()) {
            TYPE_MAP.put(type.getType(), type);
        }
    }
}

