/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class DeviceNormalSchema
implements IDeviceSchema {
    static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(DeviceNormalSchema.class) + (int)RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    private final String database;
    private final boolean isAligned;
    private final ConcurrentMap<String, SchemaCacheEntry> measurementMap = new ConcurrentHashMap<String, SchemaCacheEntry>();

    public DeviceNormalSchema(String database, boolean isAligned) {
        this.database = database;
        this.isAligned = isAligned;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public SchemaCacheEntry getSchemaCacheEntry(String measurement) {
        return (SchemaCacheEntry)this.measurementMap.get(measurement);
    }

    public int update(String[] measurements, IMeasurementSchema[] schemas) {
        int diff = 0;
        if (schemas == null) {
            return diff;
        }
        int length = measurements.length;
        for (int i = 0; i < length; ++i) {
            if (measurements[i] == null || this.measurementMap.containsKey(measurements[i])) continue;
            diff += this.putEntry(measurements[i], schemas[i], null);
        }
        return diff;
    }

    public int update(List<IMeasurementSchemaInfo> schemaInfoList) {
        return schemaInfoList.stream().mapToInt(schemaInfo -> this.putEntry(schemaInfo.getName(), schemaInfo.getSchema(), schemaInfo.getTagMap())).reduce(0, Integer::sum);
    }

    private int putEntry(String measurement, IMeasurementSchema schema, Map<String, String> tagMap) {
        SchemaCacheEntry putEntry = new SchemaCacheEntry(schema, tagMap);
        SchemaCacheEntry cachedEntry = this.measurementMap.put(measurement, putEntry);
        return Objects.isNull(cachedEntry) ? (int)(RamUsageEstimator.sizeOf((String)measurement) + (long)SchemaCacheEntry.estimateSize(putEntry) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY) : SchemaCacheEntry.estimateSize(putEntry) - SchemaCacheEntry.estimateSize(cachedEntry);
    }

    @Override
    public int estimateSize() {
        return INSTANCE_SIZE + this.measurementMap.size() * (int)RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + this.measurementMap.entrySet().stream().mapToInt(entry -> Math.toIntExact(RamUsageEstimator.sizeOf((String)((String)entry.getKey())) + (long)SchemaCacheEntry.estimateSize((SchemaCacheEntry)entry.getValue()))).reduce(0, Integer::sum);
    }
}

