/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.source;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSourceRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.datastructure.options.PipeInclusionOptions;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public abstract class IoTDBSource
implements PipeExtractor {
    protected String taskID;
    protected String pipeName;
    protected long creationTime;
    protected int regionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected boolean isForwardingPipeRequests = true;
    protected final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validate(args -> PipeInclusionOptions.optionsAreAllLegal((String)args), "The 'inclusion' string contains illegal path.", (Object)validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert")).validate(args -> PipeInclusionOptions.optionsAreAllLegal((String)args), "The 'inclusion.exclusion' string contains illegal path.", (Object)validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), "")).validate(args -> PipeInclusionOptions.hasAtLeastOneOption((String)args[0], (String)args[1]), "The pipe inclusion content can't be empty.", new Object[]{validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data.insert"), validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion.exclusion", "source.inclusion.exclusion"), "")});
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        PipeTaskSourceRuntimeEnvironment environment = (PipeTaskSourceRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.regionId = environment.getRegionId();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.taskID = this.pipeName + "_" + this.regionId + "_" + this.creationTime;
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.isForwardingPipeRequests = true;
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

