/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeAggrResult;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MaxTimeDescAggrResult
extends MaxTimeAggrResult {
    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        super.updateResultFromStatistics(statistics);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, Predicate<Long> boundPredicate) {
        if (this.hasFinalResult()) {
            return;
        }
        if (batchIterator.hasNext(boundPredicate) && !boundPredicate.test(batchIterator.currentTime())) {
            this.updateMaxTimeResult(batchIterator.currentTime());
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int timeLength;
        if (this.hasFinalResult()) {
            return;
        }
        long[] timesForFirstValue = new long[100];
        for (int currentPos = 0; currentPos < length; currentPos += timeLength) {
            timeLength = Math.min(length - currentPos, 100);
            System.arraycopy(timestamps, currentPos, timesForFirstValue, 0, timeLength);
            Object[] values = dataReader.getValuesInTimestamps(timesForFirstValue, timeLength);
            for (int i = 0; i < timeLength; ++i) {
                if (values[i] == null) continue;
                this.updateMaxTimeResult(timesForFirstValue[i]);
                return;
            }
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        if (this.hasFinalResult()) {
            return;
        }
        if (valueIterator.hasNext()) {
            this.updateMaxTimeResult(timestamps[valueIterator.getCurPos()]);
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public boolean isAscending() {
        return false;
    }
}

