/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class SeriesRawDataPointReader
implements IPointReader {
    private final SeriesRawDataBatchReader batchReader;
    private boolean hasCachedTimeValuePair;
    private BatchData batchData;
    private TimeValuePair timeValuePair;

    public SeriesRawDataPointReader(SeriesReader seriesReader) {
        this.batchReader = new SeriesRawDataBatchReader(seriesReader);
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        if (this.batchData != null && this.batchData.hasCurrent()) {
            this.timeValuePair = new TimeValuePair(this.batchData.currentTime(), this.batchData.currentTsPrimitiveType());
            this.hasCachedTimeValuePair = true;
            this.batchData.next();
            return true;
        }
        while (this.batchReader.hasNextBatch()) {
            this.batchData = this.batchReader.nextBatch();
            if (!this.batchData.hasCurrent()) continue;
            this.timeValuePair = new TimeValuePair(this.batchData.currentTime(), this.batchData.currentTsPrimitiveType());
            this.hasCachedTimeValuePair = true;
            this.batchData.next();
            return true;
        }
        return false;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair || this.hasNextTimeValuePair()) {
            this.hasCachedTimeValuePair = false;
            return this.timeValuePair;
        }
        throw new IOException("no next data");
    }

    public TimeValuePair currentTimeValuePair() {
        return this.timeValuePair;
    }

    public void close() throws IOException {
    }
}

