/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.manage.serializable.SyncLogDequeSerializer;
import org.apache.iotdb.cluster.log.snapshot.PartitionedSnapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedSnapshotLogManager<T extends Snapshot>
extends RaftLogManager {
    private static final Logger logger = LoggerFactory.getLogger(PartitionedSnapshotLogManager.class);
    Map<Integer, T> slotSnapshots = new HashMap<Integer, T>();
    private SnapshotFactory<T> factory;
    Map<Integer, Collection<TimeseriesSchema>> slotTimeseries = new HashMap<Integer, Collection<TimeseriesSchema>>();
    long snapshotLastLogIndex;
    long snapshotLastLogTerm;
    PartitionTable partitionTable;
    Node thisNode;
    DataGroupMember dataGroupMember;

    protected PartitionedSnapshotLogManager(LogApplier logApplier, PartitionTable partitionTable, Node header, Node thisNode, SnapshotFactory<T> factory, DataGroupMember dataGroupMember) {
        super(new SyncLogDequeSerializer(header.nodeIdentifier), logApplier, Integer.toString(header.getNodeIdentifier()));
        this.partitionTable = partitionTable;
        this.factory = factory;
        this.thisNode = thisNode;
        this.dataGroupMember = dataGroupMember;
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricService.getInstance().getOrCreateAutoGauge(Metric.CLUSTER_UNCOMMITTED_LOG.toString(), MetricLevel.IMPORTANT, this.getUnCommittedEntryManager().getAllEntries(), List::size, new String[]{Tag.NAME.toString(), thisNode.internalIp + "_" + dataGroupMember.getName()});
        }
    }

    public void takeSnapshotForSpecificSlots(List<Integer> requiredSlots, boolean needLeader) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot getSnapshot(long minIndex) {
        Map<Integer, T> map = this.slotSnapshots;
        synchronized (map) {
            PartitionedSnapshot<Snapshot> partitionedSnapshot = new PartitionedSnapshot<Snapshot>(this.factory);
            for (Map.Entry<Integer, T> entry : this.slotSnapshots.entrySet()) {
                partitionedSnapshot.putSnapshot(entry.getKey(), (Snapshot)entry.getValue());
            }
            partitionedSnapshot.setLastLogIndex(this.snapshotLastLogIndex);
            partitionedSnapshot.setLastLogTerm(this.snapshotLastLogTerm);
            partitionedSnapshot.truncateBefore(minIndex);
            return partitionedSnapshot;
        }
    }

    void collectTimeseriesSchemas(List<Integer> requiredSlots) {
        this.slotTimeseries.clear();
        List allSgPaths = IoTDB.metaManager.getAllStorageGroupPaths();
        HashSet<Integer> requiredSlotsSet = new HashSet<Integer>(requiredSlots);
        for (PartialPath sgPath : allSgPaths) {
            String storageGroupName = sgPath.getFullPath();
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(storageGroupName, 0L, 10000);
            if (!requiredSlotsSet.contains(slot)) continue;
            Collection schemas = this.slotTimeseries.computeIfAbsent(slot, s -> new HashSet());
            IoTDB.metaManager.collectTimeseriesSchema(sgPath, schemas);
            logger.debug("{}: {} timeseries are snapshot in slot {}", new Object[]{this.getName(), schemas.size(), slot});
        }
    }
}

