/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullTimeseriesSchemaHandler
implements AsyncMethodCallback<PullSchemaResp> {
    private static final Logger logger = LoggerFactory.getLogger(PullTimeseriesSchemaHandler.class);
    private Node owner;
    private List<String> prefixPaths;
    private AtomicReference<List<TimeseriesSchema>> timeseriesSchemas;

    public PullTimeseriesSchemaHandler(Node owner, List<String> prefixPaths, AtomicReference<List<TimeseriesSchema>> timeseriesSchemas) {
        this.owner = owner;
        this.prefixPaths = prefixPaths;
        this.timeseriesSchemas = timeseriesSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(PullSchemaResp response) {
        ByteBuffer buffer = response.schemaBytes;
        int size = buffer.getInt();
        ArrayList<TimeseriesSchema> schemas = new ArrayList<TimeseriesSchema>(size);
        for (int i = 0; i < size; ++i) {
            schemas.add(TimeseriesSchema.deserializeFrom((ByteBuffer)buffer));
        }
        AtomicReference<List<TimeseriesSchema>> atomicReference = this.timeseriesSchemas;
        synchronized (atomicReference) {
            this.timeseriesSchemas.set(schemas);
            this.timeseriesSchemas.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        logger.error("Cannot pull time series schema of {} from {}", new Object[]{this.prefixPaths, this.owner, exception});
        AtomicReference<List<TimeseriesSchema>> atomicReference = this.timeseriesSchemas;
        synchronized (atomicReference) {
            this.timeseriesSchemas.notifyAll();
        }
    }
}

