/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.IMeasure;
import com.librato.metrics.client.Maps;
import com.librato.metrics.client.Sanitizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractMeasure
implements IMeasure {
    final String name;
    Map<String, Object> metricAttributes = Collections.emptyMap();
    Integer period;
    Long epoch;

    public AbstractMeasure(AbstractMeasure measure) {
        this.name = measure.name;
        this.metricAttributes = measure.metricAttributes;
        this.period = measure.period;
        this.epoch = measure.epoch;
    }

    public AbstractMeasure(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", Sanitizer.LAST_PASS.apply(this.name));
        Maps.putIfNotNull(map, "period", this.period);
        Maps.putIfNotEmpty(map, "attributes", this.metricAttributes);
        return map;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMeasure that = (AbstractMeasure)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.metricAttributes != null ? !this.metricAttributes.equals(that.metricAttributes) : that.metricAttributes != null) {
            return false;
        }
        if (this.period != null ? !this.period.equals(that.period) : that.period != null) {
            return false;
        }
        return this.epoch != null ? this.epoch.equals(that.epoch) : that.epoch == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.metricAttributes != null ? this.metricAttributes.hashCode() : 0);
        result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
        result = 31 * result + (this.epoch != null ? this.epoch.hashCode() : 0);
        return result;
    }
}

