/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.utils;

import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.utils.KubernetesApplication;
import org.apache.livy.utils.KubernetesClientFactory$;
import org.apache.livy.utils.KubernetesExtensions;
import org.apache.livy.utils.KubernetesExtensions$;
import org.apache.livy.utils.SparkKubernetesApp;
import org.apache.livy.utils.SparkKubernetesApp$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SparkKubernetesApp$
implements Logging {
    public static SparkKubernetesApp$ MODULE$;
    private final ConcurrentHashMap<String, Object> org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags;
    private final ConcurrentHashMap<Thread, Object> org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap;
    private final ConcurrentLinkedQueue<SparkKubernetesApp> org$apache$livy$utils$SparkKubernetesApp$$appQueue;
    private final Thread leakedAppsGCThread;
    private final Thread RefreshServiceAccountTokenThread;
    private final Thread checkMonitorAppTimeoutThread;
    private LivyConf org$apache$livy$utils$SparkKubernetesApp$$livyConf;
    private int org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize;
    private FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout;
    private FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$pollInterval;
    private long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout;
    private long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval;
    private DefaultKubernetesClient kubernetesClient;
    private long appLookupThreadPoolSize;
    private long org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SparkKubernetesApp$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SparkKubernetesApp$ sparkKubernetesApp$ = this;
        synchronized (sparkKubernetesApp$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public KubernetesClient $lessinit$greater$default$6() {
        return this.kubernetesClient();
    }

    public ConcurrentHashMap<String, Object> org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags;
    }

    public ConcurrentHashMap<Thread, Object> org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap;
    }

    public ConcurrentLinkedQueue<SparkKubernetesApp> org$apache$livy$utils$SparkKubernetesApp$$appQueue() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appQueue;
    }

    private Thread leakedAppsGCThread() {
        return this.leakedAppsGCThread;
    }

    public Thread RefreshServiceAccountTokenThread() {
        return this.RefreshServiceAccountTokenThread;
    }

    private Thread checkMonitorAppTimeoutThread() {
        return this.checkMonitorAppTimeoutThread;
    }

    public LivyConf org$apache$livy$utils$SparkKubernetesApp$$livyConf() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$livyConf;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$livyConf_$eq(LivyConf x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$livyConf = x$1;
    }

    public int org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize_$eq(int x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize = x$1;
    }

    public FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout_$eq(FiniteDuration x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout = x$1;
    }

    public FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$pollInterval() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$pollInterval_$eq(FiniteDuration x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval = x$1;
    }

    public DefaultKubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    public void kubernetesClient_$eq(DefaultKubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private long appLookupThreadPoolSize() {
        return this.appLookupThreadPoolSize;
    }

    private void appLookupThreadPoolSize_$eq(long x$1) {
        this.appLookupThreadPoolSize = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes = x$1;
    }

    public void init(LivyConf livyConf, Option<KubernetesClient> client) {
        this.org$apache$livy$utils$SparkKubernetesApp$$livyConf_$eq(livyConf);
        this.kubernetesClient_$eq(KubernetesClientFactory$.MODULE$.createKubernetesClient(livyConf));
        this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize_$eq(livyConf.getInt(LivyConf$.MODULE$.SPARK_LOGS_SIZE()));
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout_$eq(new package.DurationLong(package$.MODULE$.DurationLong(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_TIMEOUT()))).milliseconds());
        this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval_$eq(new package.DurationLong(package$.MODULE$.DurationLong(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_POLL_INTERVAL()))).milliseconds());
        this.appLookupThreadPoolSize_$eq(livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_THREAD_POOL_SIZE()));
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes_$eq(livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_MAX_FAILED_TIMES()));
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval_$eq(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LEAKAGE_CHECK_INTERVAL()));
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout_$eq(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LEAKAGE_CHECK_TIMEOUT()));
        this.leakedAppsGCThread().setDaemon(true);
        this.leakedAppsGCThread().setName("LeakedAppsGCThread");
        this.leakedAppsGCThread().start();
        this.RefreshServiceAccountTokenThread().setName("RefreshServiceAccountTokenThread");
        this.RefreshServiceAccountTokenThread().setDaemon(true);
        this.RefreshServiceAccountTokenThread().start();
        this.checkMonitorAppTimeoutThread().setDaemon(true);
        this.checkMonitorAppTimeoutThread().setName("CheckMonitorAppTimeoutThread");
        this.checkMonitorAppTimeoutThread().start();
        this.initKubernetesAppMonitorThreadPool(livyConf);
    }

    public Option<KubernetesClient> init$default$2() {
        return None$.MODULE$;
    }

    public <T> T org$apache$livy$utils$SparkKubernetesApp$$withRetry(Function0<T> fn, int n, long retryBackoff) {
        Try try_;
        while (true) {
            if ((try_ = Try$.MODULE$.apply(fn)) instanceof Success) {
                Success success = (Success)try_;
                Object x = success.value();
                return (T)x;
            }
            if (n <= 1) break;
            Thread.sleep(Math.max(retryBackoff, 3000L));
            retryBackoff = this.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3();
            --n;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public <T> int org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2() {
        return 10;
    }

    public <T> long org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3() {
        return 3000L;
    }

    private void initKubernetesAppMonitorThreadPool(LivyConf livyConf) {
        int poolSize = livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_THREAD_POOL_SIZE());
        ExecutorService KubernetesAppMonitorThreadPool = Executors.newFixedThreadPool(poolSize);
        SparkKubernetesApp.KubernetesAppMonitorRunnable runnable = new SparkKubernetesApp.KubernetesAppMonitorRunnable();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), poolSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> KubernetesAppMonitorThreadPool.execute(runnable));
    }

    public int getAppSize() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appQueue().size();
    }

    public void clearApps() {
        this.org$apache$livy$utils$SparkKubernetesApp$$appQueue().clear();
    }

    private SparkKubernetesApp$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags = new ConcurrentHashMap();
        this.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap = new ConcurrentHashMap();
        this.org$apache$livy$utils$SparkKubernetesApp$$appQueue = new ConcurrentLinkedQueue();
        this.leakedAppsGCThread = new Thread(){

            public void run() {
                while (true) {
                    if (!SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags().isEmpty()) {
                        Iterator<Map.Entry<String, Object>> iter = SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags().entrySet().iterator();
                        BooleanRef isRemoved = BooleanRef.create((boolean)false);
                        long now = System.currentTimeMillis();
                        Seq apps = (Seq)SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry((Function0 & Serializable & scala.Serializable)() -> {
                            KubernetesExtensions.KubernetesClientExtensions qual$1 = KubernetesExtensions$.MODULE$.KubernetesClientExtensions((KubernetesClient)SparkKubernetesApp$.MODULE$.kubernetesClient());
                            Map<String, String> x$1 = qual$1.getApplications$default$1();
                            String x$2 = qual$1.getApplications$default$2();
                            String x$3 = qual$1.getApplications$default$3();
                            return qual$1.getApplications(x$1, x$2, x$3);
                        }, SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2(), SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3());
                        while (iter.hasNext()) {
                            Map.Entry<String, Object> entry = iter.next();
                            apps.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$2(entry, x$1))).foreach((Function1 & Serializable & scala.Serializable)app -> {
                                anon.1.$anonfun$run$3(iter, isRemoved, app);
                                return BoxedUnit.UNIT;
                            });
                            if (isRemoved.elem || BoxesRunTime.unboxToLong((Object)entry.getValue()) - now <= SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout()) continue;
                            iter.remove();
                            SparkKubernetesApp$.MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Remove leaked Kubernetes app tag ").append(entry.getKey()).toString());
                        }
                    }
                    Thread.sleep(SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval());
                }
            }

            public static final /* synthetic */ boolean $anonfun$run$2(Map.Entry entry$1, KubernetesApplication x$1) {
                return x$1.getApplicationTag().contains((CharSequence)entry$1.getKey());
            }

            public static final /* synthetic */ void $anonfun$run$3(Iterator iter$1, BooleanRef isRemoved$1, KubernetesApplication app) {
                SparkKubernetesApp$.MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Kill leaked app ").append(app.getApplicationId()).toString());
                SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KubernetesExtensions$.MODULE$.KubernetesClientExtensions((KubernetesClient)SparkKubernetesApp$.MODULE$.kubernetesClient()).killApplication(app), SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2(), SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3());
                iter$1.remove();
                isRemoved$1.elem = true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(java.util.Map$Entry org.apache.livy.utils.KubernetesApplication ), $anonfun$run$3$adapted(java.util.Iterator scala.runtime.BooleanRef org.apache.livy.utils.KubernetesApplication ), $anonfun$run$6(java.util.Map$Entry ), $anonfun$run$4(org.apache.livy.utils.KubernetesApplication ), $anonfun$run$5(org.apache.livy.utils.KubernetesApplication )}, serializedLambda);
            }
        };
        this.RefreshServiceAccountTokenThread = new Thread(){

            public void run() {
                while (true) {
                    Context currentContext = new Context();
                    String currentContextName = new String();
                    Config config = SparkKubernetesApp$.MODULE$.kubernetesClient().getConfiguration();
                    if (config.getCurrentContext() != null) {
                        currentContext = config.getCurrentContext().getContext();
                        currentContextName = config.getCurrentContext().getName();
                    }
                    ObjectRef newAccessToken = ObjectRef.create((Object)new String());
                    Config newestConfig = Config.autoConfigure((String)currentContextName);
                    newAccessToken.elem = newestConfig.getOauthToken();
                    SparkKubernetesApp$.MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Refresh a new token ").append((String)newAccessToken$1.elem).toString());
                    config.setOauthToken((String)newAccessToken.elem);
                    SparkKubernetesApp$.MODULE$.kubernetesClient_$eq(new DefaultKubernetesClient(config));
                    Thread.sleep(300000L);
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$7(scala.runtime.ObjectRef )}, serializedLambda);
            }
        };
        this.checkMonitorAppTimeoutThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Iterator<Map.Entry<Thread, Object>> iter = SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap().entrySet().iterator();
                        long now = System.currentTimeMillis();
                        while (iter.hasNext()) {
                            Map.Entry<Thread, Object> entry = iter.next();
                            Thread thread = entry.getKey();
                            long updatedTime = BoxesRunTime.unboxToLong((Object)entry.getValue());
                            long remaining = now - updatedTime - SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$pollInterval().toMillis();
                            if (remaining <= SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout().toMillis()) continue;
                            thread.interrupt();
                        }
                        Thread.sleep(SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$pollInterval().toMillis());
                        continue;
                    }
                    catch (InterruptedException e) {
                        SparkKubernetesApp$.MODULE$.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Apps timeout monitoring thread was interrupted.", e);
                        continue;
                    }
                    break;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$8()}, serializedLambda);
            }
        };
    }
}

