/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.kryo.kryo.factories;

import org.apache.livy.shaded.kryo.kryo.Kryo;
import org.apache.livy.shaded.kryo.kryo.Serializer;
import org.apache.livy.shaded.kryo.kryo.factories.SerializerFactory;
import org.apache.livy.shaded.kryo.kryo.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionSerializerFactory
implements SerializerFactory {
    private final Class<? extends Serializer> serializerClass;

    public ReflectionSerializerFactory(Class<? extends Serializer> serializerClass) {
        this.serializerClass = serializerClass;
    }

    @Override
    public Serializer makeSerializer(Kryo kryo, Class<?> type) {
        return ReflectionSerializerFactory.makeSerializer(kryo, this.serializerClass, type);
    }

    public static Serializer makeSerializer(Kryo kryo, Class<? extends Serializer> serializerClass, Class<?> type) {
        try {
            try {
                return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(kryo, type);
            }
            catch (NoSuchMethodException ex1) {
                try {
                    return serializerClass.getConstructor(Kryo.class).newInstance(kryo);
                }
                catch (NoSuchMethodException ex2) {
                    try {
                        return serializerClass.getConstructor(Class.class).newInstance(type);
                    }
                    catch (NoSuchMethodException ex3) {
                        return serializerClass.newInstance();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + Util.className(type), ex);
        }
    }
}

