/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.cli;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLServerSocket;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.livy.LivyConf$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.thriftserver.LivyCLIService;
import org.apache.livy.thriftserver.auth.AuthFactory;
import org.apache.livy.thriftserver.cli.ThreadPoolExecutorWithOomHook;
import org.apache.livy.thriftserver.cli.ThriftCLIServerContext;
import org.apache.livy.thriftserver.cli.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001b\t1B\u000b\u001b:jMR\u0014\u0015N\\1ss\u000ec\u0015jU3sm&\u001cWM\u0003\u0002\u0004\t\u0005\u00191\r\\5\u000b\u0005\u00151\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\u0004\t\u0003\u0011a\u0017N^=\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u0001B\u000b\u001b:jMR\u001cE*S*feZL7-\u001a\u0005\t'\u0001\u0011)\u0019!C!)\u0005Q1\r\\5TKJ4\u0018nY3\u0016\u0003U\u0001\"AF\f\u000e\u0003\u0011I!\u0001\u0007\u0003\u0003\u001d1Kg/_\"M\u0013N+'O^5dK\"I!\u0004\u0001B\u0001B\u0003%QcG\u0001\fG2L7+\u001a:wS\u000e,\u0007%\u0003\u0002\u0014!!AQ\u0004\u0001BC\u0002\u0013\u0005a$A\u0004p_6Dun\\6\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0005Sk:t\u0017M\u00197f\u0011!A\u0003A!A!\u0002\u0013y\u0012\u0001C8p[\"{wn\u001b\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003\u001f\u0001AQaE\u0015A\u0002UAQ!H\u0015A\u0002}A\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011C\u0019\u0002\rM,'O^3s+\u0005\u0011\u0004CA\u001a8\u001b\u0005!$B\u0001\u00196\u0015\t1\u0004\"\u0001\u0004uQJLg\r^\u0005\u0003qQ\u0012q\u0001V*feZ,'\u000fC\u0005;\u0001\u0001\u0007\t\u0019!C\tw\u0005Q1/\u001a:wKJ|F%Z9\u0015\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$\u0001B+oSRDqaQ\u001d\u0002\u0002\u0003\u0007!'A\u0002yIEBa!\u0012\u0001!B\u0013\u0011\u0014aB:feZ,'\u000f\t\u0005\t\u000f\u0002A)\u0019!C!\u0011\u0006y\u0001.\u001b<f\u0003V$\bNR1di>\u0014\u00180F\u0001J!\tQU*D\u0001L\u0015\taE!\u0001\u0003bkRD\u0017B\u0001(L\u0005-\tU\u000f\u001e5GC\u000e$xN]=\t\u0011A\u0003\u0001\u0012!Q!\n%\u000b\u0001\u0003[5wK\u0006+H\u000f\u001b$bGR|'/\u001f\u0011\t\u000bI\u0003A\u0011C*\u0002\u0015%t\u0017\u000e^*feZ,'\u000fF\u0001=\u0011\u0015)\u0006\u0001\"\u0011T\u0003\r\u0011XO\u001c\u0005\u0006/\u0002!\tbU\u0001\u000bgR|\u0007oU3sm\u0016\u0014\b")
public class ThriftBinaryCLIService
extends ThriftCLIService {
    private final Runnable oomHook;
    private TServer server;
    private AuthFactory hiveAuthFactory;
    private volatile boolean bitmap$0;

    private AuthFactory hiveAuthFactory$lzycompute() {
        ThriftBinaryCLIService thriftBinaryCLIService = this;
        synchronized (thriftBinaryCLIService) {
            if (!this.bitmap$0) {
                this.hiveAuthFactory = new AuthFactory(this.livyConf());
                this.bitmap$0 = true;
            }
            return this.hiveAuthFactory;
        }
    }

    @Override
    public LivyCLIService cliService() {
        return super.cliService();
    }

    public Runnable oomHook() {
        return this.oomHook;
    }

    public TServer server() {
        return this.server;
    }

    public void server_$eq(TServer x$1) {
        this.server = x$1;
    }

    @Override
    public AuthFactory hiveAuthFactory() {
        return this.bitmap$0 ? this.hiveAuthFactory : this.hiveAuthFactory$lzycompute();
    }

    @Override
    public void initServer() {
        try {
            InetSocketAddress serverAddress;
            ThreadPoolExecutorWithOomHook executorService = new ThreadPoolExecutorWithOomHook(this.minWorkerThreads(), this.maxWorkerThreads(), this.workerKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new ThreadFactoryWithGarbageCleanup("LivyThriftserver-Handler-Pool"), this.oomHook());
            TTransportFactory transportFactory = this.hiveAuthFactory().getAuthTransFactory();
            TProcessorFactory processorFactory = this.hiveAuthFactory().getAuthProcFactory(this);
            TServerSocket serverSocket = null;
            InetSocketAddress inetSocketAddress = serverAddress = this.hiveHost() == null || this.hiveHost().isEmpty() ? new InetSocketAddress(this.portNum()) : new InetSocketAddress(this.hiveHost(), this.portNum());
            if (this.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_USE_SSL())) {
                ArrayList sslVersionBlacklist = new ArrayList();
                Predef$.MODULE$.refArrayOps((Object[])this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_SSL_PROTOCOL_BLACKLIST()).split(",")).foreach((Function1)new Serializable(this, sslVersionBlacklist){
                    public static final long serialVersionUID = 0L;
                    private final ArrayList sslVersionBlacklist$1;

                    public final boolean apply(String sslVersion) {
                        return this.sslVersionBlacklist$1.add(sslVersion.trim().toLowerCase());
                    }
                    {
                        this.sslVersionBlacklist$1 = sslVersionBlacklist$1;
                    }
                });
                String keyStorePath = this.livyConf().get((ClientConf.ConfEntry)LivyConf$.MODULE$.SSL_KEYSTORE()).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Not configured for SSL connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.SSL_KEYSTORE().key()})));
                }
                String keyStorePassword = this.getKeyStorePassword();
                TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
                params.setKeyStore(keyStorePath, keyStorePassword);
                serverSocket = TSSLTransportFactory.getServerSocket((int)this.portNum(), (int)0, (InetAddress)serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
                if (serverSocket.getServerSocket() instanceof SSLServerSocket) {
                    SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket.getServerSocket();
                    String[] enabledProtocols = (String[])Predef$.MODULE$.refArrayOps((Object[])sslServerSocket.getEnabledProtocols()).filter((Function1)new Serializable(this, sslVersionBlacklist){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ThriftBinaryCLIService $outer;
                        private final ArrayList sslVersionBlacklist$1;

                        public final boolean apply(String protocol) {
                            boolean bl;
                            if (this.sslVersionBlacklist$1.contains(protocol.toLowerCase())) {
                                this.$outer.debug((Function0<Object>)new Serializable(this, protocol){
                                    public static final long serialVersionUID = 0L;
                                    private final String protocol$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disabling SSL Protocol: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocol$1}));
                                    }
                                    {
                                        this.protocol$1 = protocol$1;
                                    }
                                });
                                bl = false;
                            } else {
                                bl = true;
                            }
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sslVersionBlacklist$1 = sslVersionBlacklist$1;
                        }
                    });
                    sslServerSocket.setEnabledProtocols(enabledProtocols);
                    this.info((Function0<Object>)new Serializable(this, sslServerSocket){
                        public static final long serialVersionUID = 0L;
                        private final SSLServerSocket sslServerSocket$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SSL Server Socket Enabled Protocols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sslServerSocket$1.getEnabledProtocols()}));
                        }
                        {
                            this.sslServerSocket$1 = sslServerSocket$1;
                        }
                    });
                }
            } else {
                serverSocket = new TServerSocket(serverAddress);
            }
            int maxMessageSize = this.livyConf().getInt((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_MAX_MESSAGE_SIZE());
            int requestTimeout = (int)this.livyConf().getTimeAsMs((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_LOGIN_TIMEOUT());
            int beBackoffSlotLength = (int)this.livyConf().getTimeAsMs((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_LOGIN_BEBACKOFF_SLOT_LENGTH());
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverSocket).processorFactory(processorFactory).transportFactory(transportFactory).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory()).inputProtocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true, (long)maxMessageSize, (long)maxMessageSize))).requestTimeout(requestTimeout).requestTimeoutUnit(TimeUnit.MILLISECONDS).beBackoffSlotLength(beBackoffSlotLength).beBackoffSlotLengthUnit(TimeUnit.MILLISECONDS).executorService((ExecutorService)executorService);
            this.server_$eq((TServer)new TThreadPoolServer(sargs));
            this.server().setServerEventHandler(new TServerEventHandler(this){
                private final /* synthetic */ ThriftBinaryCLIService $outer;

                public ServerContext createContext(TProtocol input, TProtocol output) {
                    return new ThriftCLIServerContext();
                }

                public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
                    ThriftCLIServerContext context = (ThriftCLIServerContext)serverContext;
                    SessionHandle sessionHandle = context.getSessionHandle();
                    if (sessionHandle != null) {
                        this.$outer.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Session disconnected without closing properly. ";
                            }
                        });
                        try {
                            boolean close2 = this.$outer.livyConf().getBoolean((ClientConf.ConfEntry)LivyConf$.MODULE$.THRIFT_CLOSE_SESSION_ON_DISCONNECT());
                            this.$outer.info((Function0<Object>)new Serializable(this, sessionHandle){
                                public static final long serialVersionUID = 0L;
                                private final SessionHandle sessionHandle$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Closing the session: ").append((Object)this.sessionHandle$1).toString();
                                }
                                {
                                    this.sessionHandle$1 = sessionHandle$1;
                                }
                            });
                            if (close2) {
                                this.$outer.cliService().closeSession(sessionHandle);
                            }
                        }
                        catch (HiveSQLException hiveSQLException) {
                            this.$outer.warn((Function0<Object>)new Serializable(this, hiveSQLException){
                                public static final long serialVersionUID = 0L;
                                private final HiveSQLException e$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Failed to close session: ").append((Object)((Object)this.e$1)).toString();
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            }, hiveSQLException);
                        }
                    }
                }

                public void preServe() {
                }

                public void processContext(ServerContext serverContext, TTransport input, TTransport output) {
                    this.$outer.currentServerContext().set(serverContext);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.info((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThriftBinaryCLIService $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting ", " on port ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ThriftBinaryCLIService.class.getSimpleName(), BoxesRunTime.boxToInteger((int)this.$outer.portNum())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", "...", " worker threads"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.minWorkerThreads()), BoxesRunTime.boxToInteger((int)this.$outer.maxWorkerThreads())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to init thrift server", exception);
        }
    }

    @Override
    public void run() {
        try {
            this.server().serve();
        }
        catch (Throwable throwable) {
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThriftBinaryCLIService $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception caught by ", ". Exiting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getClass().getSimpleName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, throwable);
            System.exit(-1);
        }
        catch (InterruptedException interruptedException) {
            this.info((Function0<Object>)new Serializable(this, interruptedException){
                public static final long serialVersionUID = 0L;
                private final InterruptedException t$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Caught ", ". Shutting down thrift server."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1.getClass().getSimpleName()}));
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    @Override
    public void stopServer() {
        this.server().stop();
        this.server_$eq(null);
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Thrift server has stopped";
            }
        });
    }

    public ThriftBinaryCLIService(LivyCLIService cliService, Runnable oomHook) {
        this.oomHook = oomHook;
        super(cliService, ThriftBinaryCLIService.class.getSimpleName());
    }
}

