/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy;

import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Map<String, String> getPropertiesFromFile(File file) {
        return this.loadProperties(file.toURI().toURL());
    }

    public Map<String, String> loadProperties(URL url) {
        InputStreamReader inReader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        try {
            Properties properties = new Properties();
            properties.load(inReader);
            return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)this.properties$1.getProperty(k).trim());
                }
                {
                    this.properties$1 = properties$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        }
        finally {
            inReader.close();
        }
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost) throws TimeoutException, InterruptedException {
        long endTime = System.currentTimeMillis() + atMost.toMillis();
        this.aux$1(1, checkForEvent, endTime);
    }

    public boolean isProcessAlive(Process process) {
        boolean bl;
        try {
            process.exitValue();
            bl = false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Thread startDaemonThread(String name, Function0<BoxedUnit> f) {
        void var3_3;
        Thread thread = new Thread(name, f){
            private final Function0 f$1;

            public void run() {
                this.f$1.apply$mcV$sp();
            }
            {
                this.f$1 = f$1;
                super(name$1);
            }
        };
        thread.setDaemon(true);
        thread.start();
        return var3_3;
    }

    public <A extends Closeable, B> B usingResource(A resource, Function1<A, B> f) {
        try {
            return (B)f.apply(resource);
        }
        finally {
            resource.close();
        }
    }

    private final void aux$1(int count, Function0 checkForEvent$1, long endTime$1) {
        while (true) {
            if (checkForEvent$1.apply$mcZ$sp()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= endTime$1) break;
            int sleepTime = Math.max(10 * (2 << count - 1), 1000);
            Thread.sleep(sleepTime);
            ++count;
        }
        throw new TimeoutException();
    }

    private Utils$() {
        MODULE$ = this;
    }
}

