/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.io.Serializable;
import org.mvel2.MVELRuntime;
import org.mvel2.ParserConfiguration;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.TypeCast;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.integration.impl.StackResetResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.ASTLinkedList;

public class CompiledExpression
implements Serializable,
ExecutableStatement {
    private ASTNode firstNode;
    private Class knownEgressType;
    private Class knownIngressType;
    private boolean convertableIngressEgress;
    private boolean optimized = false;
    private boolean importInjectionRequired = false;
    private boolean literalOnly;
    private Class<? extends AccessorOptimizer> accessorOptimizer;
    private String sourceName;
    private ParserConfiguration parserConfiguration;

    public CompiledExpression(ASTLinkedList astMap, String sourceName, Class egressType, ParserConfiguration parserConfiguration, boolean literalOnly) {
        this.firstNode = astMap.firstNode();
        this.sourceName = sourceName;
        this.knownEgressType = astMap.isSingleNode() ? astMap.firstNonSymbol().getEgressType() : egressType;
        this.literalOnly = literalOnly;
        this.parserConfiguration = parserConfiguration;
        this.importInjectionRequired = !parserConfiguration.getImports().isEmpty();
    }

    public ASTNode getFirstNode() {
        return this.firstNode;
    }

    public boolean isSingleNode() {
        return this.firstNode != null && this.firstNode.nextASTNode == null;
    }

    @Override
    public Class getKnownEgressType() {
        return this.knownEgressType;
    }

    @Override
    public void setKnownEgressType(Class knownEgressType) {
        this.knownEgressType = knownEgressType;
    }

    @Override
    public Class getKnownIngressType() {
        return this.knownIngressType;
    }

    @Override
    public void setKnownIngressType(Class knownIngressType) {
        this.knownIngressType = knownIngressType;
    }

    @Override
    public boolean isConvertableIngressEgress() {
        return this.convertableIngressEgress;
    }

    @Override
    public void computeTypeConversionRule() {
        if (this.knownIngressType != null && this.knownEgressType != null) {
            this.convertableIngressEgress = this.knownIngressType.isAssignableFrom(this.knownEgressType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (!this.optimized) {
            this.setupOptimizers();
            try {
                Object object = this.getValue(ctx, variableFactory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.getValue(ctx, variableFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        if (!this.optimized) {
            this.setupOptimizers();
            try {
                Object object = this.getValue(staticContext, factory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return this.getDirectValue(staticContext, factory);
    }

    public Object getDirectValue(Object staticContext, VariableResolverFactory factory) {
        return MVELRuntime.execute(false, this, staticContext, this.importInjectionRequired ? new ClassImportResolverFactory(this.parserConfiguration, factory, true) : new StackResetResolverFactory(factory));
    }

    private void setupOptimizers() {
        if (this.accessorOptimizer != null) {
            OptimizerFactory.setThreadAccessorOptimizer(this.accessorOptimizer);
        }
        this.optimized = true;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public Class<? extends AccessorOptimizer> getAccessorOptimizer() {
        return this.accessorOptimizer;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public boolean intOptimized() {
        return false;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public boolean isImportInjectionRequired() {
        return this.importInjectionRequired;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    @Override
    public boolean isLiteralOnly() {
        return this.literalOnly;
    }

    @Override
    public boolean isEmptyStatement() {
        return this.firstNode == null;
    }

    @Override
    public boolean isExplicitCast() {
        return this.firstNode != null && this.firstNode instanceof TypeCast;
    }

    public String toString() {
        StringBuilder appender = new StringBuilder();
        ASTNode node = this.firstNode;
        while (node != null) {
            appender.append(node.toString()).append(";\n");
            node = node.nextASTNode;
        }
        return appender.toString();
    }
}

