/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.exception.BadRequestException;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.InternalErrorException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllReply;
import org.apache.bifromq.inbox.rpc.proto.ExpireAllRequest;
import org.apache.bifromq.inbox.server.ITenantGCRunner;
import org.apache.bifromq.inbox.storage.proto.ExpireTenantReply;
import org.apache.bifromq.inbox.storage.proto.ExpireTenantRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantGCRunner
implements ITenantGCRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantGCRunner.class);
    private final IBaseKVStoreClient storeClient;

    public TenantGCRunner(IBaseKVStoreClient storeClient) {
        this.storeClient = storeClient;
    }

    @Override
    public CompletableFuture<ExpireAllReply> expire(ExpireAllRequest request) {
        ByteString tenantBeginKey = KVSchemaUtil.tenantBeginKeyPrefix((String)request.getTenantId());
        Collection rangeSettingList = KVRangeRouterUtil.findByBoundary((Boundary)BoundaryUtil.toBoundary((ByteString)tenantBeginKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantBeginKey)), (NavigableMap)this.storeClient.latestEffectiveRouter());
        if (rangeSettingList.isEmpty()) {
            return CompletableFuture.completedFuture(ExpireAllReply.newBuilder().setReqId(request.getReqId()).setCode(ExpireAllReply.Code.OK).build());
        }
        CompletableFuture[] gcResults = (CompletableFuture[])rangeSettingList.stream().map(setting -> this.expire((KVRangeSetting)setting, request.getTenantId(), request.getExpirySeconds(), request.getNow())).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(gcResults).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                if (e instanceof BadVersionException || e instanceof TryLaterException || e instanceof ServerNotFoundException) {
                    return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setCode(ExpireAllReply.Code.TRY_LATER).build();
                }
                log.debug("[InboxGC] Failed to do gc: reqId={}", (Object)request.getReqId(), e);
                return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setCode(ExpireAllReply.Code.ERROR).build();
            }
            return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setCode(ExpireAllReply.Code.OK).build();
        }));
    }

    private CompletableFuture<ExpireTenantReply> expire(KVRangeSetting rangeSetting, String tenantId, Integer expirySeconds, long now) {
        long reqId = System.nanoTime();
        return this.storeClient.query(rangeSetting.leader(), KVRangeRORequest.newBuilder().setReqId(reqId).setKvRangeId(rangeSetting.id()).setVer(rangeSetting.ver()).setRoCoProc(ROCoProcInput.newBuilder().setInboxService(this.buildRequest(reqId, tenantId, expirySeconds, now)).build()).build()).thenApply(v -> {
            switch (v.getCode()) {
                case Ok: {
                    return v.getRoCoProcResult().getInboxService().getExpireTenant();
                }
                case BadRequest: {
                    throw new BadRequestException();
                }
                case BadVersion: {
                    throw new BadVersionException();
                }
                case TryLater: {
                    throw new TryLaterException();
                }
            }
            throw new InternalErrorException();
        });
    }

    private InboxServiceROCoProcInput buildRequest(long reqId, String tenantId, Integer expirySeconds, long now) {
        return InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setExpireTenant(ExpireTenantRequest.newBuilder().setNow(now).setTenantId(tenantId).setExpirySeconds(expirySeconds.intValue()).build()).build();
    }
}

