/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.record;

import java.util.Comparator;
import org.apache.bifromq.inbox.record.InboxInstance;
import org.apache.bifromq.inbox.util.InboxServiceUtil;
import org.apache.bifromq.type.MatchInfo;

public record TenantInboxInstance(String tenantId, InboxInstance instance) implements Comparable<TenantInboxInstance>
{
    private static final Comparator<TenantInboxInstance> COMPARATOR = Comparator.comparing(TenantInboxInstance::tenantId).thenComparing(a -> a.instance().inboxId()).thenComparing(a -> a.instance().incarnation());

    public static TenantInboxInstance from(String tenantId, MatchInfo subInfo) {
        return new TenantInboxInstance(tenantId, InboxServiceUtil.parseReceiverId(subInfo.getReceiverId()));
    }

    public String receiverId() {
        return this.instance.receiverId();
    }

    @Override
    public int compareTo(TenantInboxInstance o) {
        return COMPARATOR.compare(this, o);
    }
}

