/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.List;
import java.util.Optional;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.record.SubTasks;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.UserProperties;

public interface IMQTTProtocolHelper {
    public UserProperties getUserProps(MqttPublishMessage var1);

    public UserProperties getUserProps(MqttUnsubscribeMessage var1);

    public boolean checkPacketIdUsage();

    public ProtocolResponse onInboxTransientError(String var1);

    public ProtocolResponse onInboxBusy(String var1);

    public Optional<Integer> sessionExpiryIntervalOnDisconnect(MqttMessage var1);

    public ProtocolResponse onServerShuttingDown();

    public ProtocolResponse onResourceExhaustedDisconnect(TenantResourceType var1);

    public ProtocolResponse respondDisconnectProtocolError();

    public boolean isNormalDisconnect(MqttMessage var1);

    public boolean isDisconnectWithLWT(MqttMessage var1);

    public ProtocolResponse respondDecodeError(MqttMessage var1);

    public ProtocolResponse respondDuplicateConnect(MqttConnectMessage var1);

    public ProtocolResponse validateSubMessage(MqttSubscribeMessage var1);

    public SubTasks getSubTask(MqttSubscribeMessage var1);

    public ProtocolResponse onSubBackPressured(MqttSubscribeMessage var1);

    public ProtocolResponse buildSubAckMessage(MqttSubscribeMessage var1, List<SubResult> var2);

    public MqttSubAckMessage respondPacketIdInUse(MqttSubscribeMessage var1);

    public ProtocolResponse validateUnsubMessage(MqttUnsubscribeMessage var1);

    public MqttUnsubAckMessage respondPacketIdInUse(MqttUnsubscribeMessage var1);

    public ProtocolResponse onUnsubBackPressured(MqttUnsubscribeMessage var1);

    public ProtocolResponse buildUnsubAckMessage(MqttUnsubscribeMessage var1, List<UnsubResult> var2);

    public MqttMessage onPubRelReceived(MqttMessage var1, boolean var2);

    public boolean isQoS2Received(MqttMessage var1);

    public ProtocolResponse respondPubRecMsg(MqttMessage var1, boolean var2);

    public int clientReceiveMaximum();

    public ProtocolResponse onKick(ClientInfo var1);

    public ProtocolResponse onRedirect(boolean var1, String var2);

    public MqttPublishMessage buildMqttPubMessage(int var1, RoutedMessage var2, boolean var3);

    public ProtocolResponse respondReceivingMaximumExceeded(MqttPublishMessage var1);

    public ProtocolResponse respondPubRateExceeded(MqttPublishMessage var1);

    public ProtocolResponse validatePubMessage(MqttPublishMessage var1);

    public String getTopic(MqttPublishMessage var1);

    public Message buildDistMessage(MqttPublishMessage var1, ClientInfo var2);

    public ProtocolResponse onQoS0DistDenied(String var1, Message var2, CheckResult var3);

    public ProtocolResponse onQoS0PubHandled(PubResult var1, MqttPublishMessage var2, UserProperties var3);

    public ProtocolResponse onQoS1DistDenied(String var1, int var2, Message var3, CheckResult var4);

    public ProtocolResponse respondQoS1PacketInUse(MqttPublishMessage var1);

    public ProtocolResponse onQoS1PubHandled(PubResult var1, MqttPublishMessage var2, UserProperties var3);

    public ProtocolResponse respondQoS2PacketInUse(MqttPublishMessage var1);

    public ProtocolResponse onQoS2DistDenied(String var1, int var2, Message var3, CheckResult var4);

    public ProtocolResponse onQoS2PubHandled(PubResult var1, MqttPublishMessage var2, UserProperties var3);

    public ProtocolResponse onIdleTimeout(int var1);

    public static enum UnsubResult {
        OK,
        NO_SUB,
        NOT_AUTHORIZED,
        TOPIC_FILTER_INVALID,
        BACK_PRESSURE_REJECTED,
        TRY_LATER,
        ERROR;

    }

    public static enum SubResult {
        OK,
        EXISTS,
        EXCEED_LIMIT,
        NOT_AUTHORIZED,
        TOPIC_FILTER_INVALID,
        WILDCARD_NOT_SUPPORTED,
        SHARED_SUBSCRIPTION_NOT_SUPPORTED,
        SUBSCRIPTION_IDENTIFIER_NOT_SUPPORTED,
        BACK_PRESSURE_REJECTED,
        TRY_LATER,
        ERROR;

    }
}

